/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.AbstractEncryptOptionsEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.ClientUtils;
import com.yeepay.yop.sdk.utils.Encodes;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class Sm4Enhancer
extends AbstractEncryptOptionsEnhancer {
    private final String provider;
    private final String env;
    private final String appKey;

    public Sm4Enhancer(String appKey) {
        this.provider = "";
        this.env = "";
        this.appKey = appKey;
    }

    public Sm4Enhancer(String provider, String env, String appKey) {
        this.provider = provider;
        this.env = env;
        this.appKey = appKey;
    }

    public EncryptOptions enhance(EncryptOptions source) {
        if (!this.checkForEnhance(source)) {
            return source;
        }
        List mainKeys = ClientUtils.getCurrentCredentialsProvider().getIsvEncryptKey(this.provider, this.env, this.appKey);
        if (CollectionUtils.isEmpty((Collection)mainKeys)) {
            throw new YopClientException("ConfigProblem, IsvEncryptKey NotFound, appKey:" + this.appKey);
        }
        EncryptOptions mainKeyOptions = source.copy();
        String mainCredential = ((YopCertConfig)mainKeys.get(0)).getValue();
        mainKeyOptions.setCredentials((Object)new YopSymmetricCredentials(this.appKey, mainCredential));
        String credentialStr = ((YopSymmetricCredentials)source.getCredentials()).getCredential();
        byte[] credentialBytes = Encodes.decodeBase64(credentialStr);
        source.setEncryptedCredentials(YopEncryptorFactory.getEncryptor("SM4/CBC/PKCS5Padding").encryptToBase64(credentialBytes, mainKeyOptions));
        source.setCredentials((Object)new YopSymmetricCredentials(this.appKey, credentialStr));
        source.setCredentialsAlg("SM4/CBC/PKCS5Padding");
        source.enhance("SM4_CERT_ID", (Object)mainCredential);
        return source;
    }
}

