/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopCallbackException;
import com.yeepay.yop.sdk.security.encrypt.BigParamEncryptMode;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum YopEncryptProtocol {
    YOP_ENCRYPT_PROTOCOL_V1_REQ("yop-encrypt-v1"){

        @Override
        public Inst parse(ParseParams parseParams) {
            EncryptOptions srcEncryptOptions = parseParams.getSrcEncryptOptions();
            EncryptOptions parsedEncryptOptions = srcEncryptOptions.copy();
            String[] items = StringUtils.splitPreserveAllTokens((String)parseParams.getYopEncrypt(), (String)"/");
            YopEncryptProtocol.parseBasic(items, parsedEncryptOptions);
            YopEncryptProtocol.parseCredentials(items, parsedEncryptOptions, parseParams.getYopCredentials());
            String encryptHeaderStr = items[6];
            String encryptParamStr = items[7];
            return new Inst(parsedEncryptOptions, 1.parseEncryptItems(encryptHeaderStr, false), 1.parseEncryptItems(encryptParamStr, true));
        }
    };

    private static final Logger LOGGER;
    private String protocolPrefix;
    private static final Map<String, YopEncryptProtocol> protocolMap;

    private YopEncryptProtocol(String protocolPrefix) {
        this.protocolPrefix = protocolPrefix;
    }

    public static Set<String> parseEncryptItems(String itemStr, boolean base64) {
        try {
            if (StringUtils.isNotBlank((CharSequence)itemStr)) {
                String itemStrDecoded = base64 && !itemStr.equals("$") ? new String(Encodes.decodeBase64(itemStr), "UTF-8") : itemStr;
                return Arrays.stream(itemStrDecoded.split(";")).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
        catch (UnsupportedEncodingException e) {
            throw new YopCallbackException("error when parse encrypt protocol, ex:", (Throwable)e);
        }
    }

    public static YopEncryptProtocol fromProtocol(String protocol) {
        return protocolMap.get(StringUtils.substringBefore((String)protocol, (String)"/"));
    }

    public static YopEncryptProtocol fromProtocolPrefix(String protocolPrefix) {
        return protocolMap.get(protocolPrefix);
    }

    public String getProtocolPrefix() {
        return this.protocolPrefix;
    }

    public abstract Inst parse(ParseParams var1);

    private static void parseBasic(String[] items, EncryptOptions parsedEncryptOptions) {
        if (StringUtils.isNotBlank((CharSequence)items[4])) {
            String[] iv_AAD = StringUtils.splitPreserveAllTokens((String)items[4], (String)";");
            parsedEncryptOptions.setIv(iv_AAD[0]);
            if (iv_AAD.length > 1) {
                parsedEncryptOptions.setAad(iv_AAD[1]);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)items[2])) {
            parsedEncryptOptions.setAlg(StringUtils.replace((String)items[2], (String)"_", (String)"/"));
        }
        if (StringUtils.isNotBlank((CharSequence)items[5])) {
            parsedEncryptOptions.setBigParamEncryptMode(BigParamEncryptMode.valueOf((String)items[5]));
        }
    }

    private static void parseCredentials(String[] items, EncryptOptions parsedEncryptOptions, YopCredentials<?> yopCredentials) {
        Object credential = parsedEncryptOptions.getCredentials();
        String credentialsAlg = parsedEncryptOptions.getCredentialsAlg();
        if (StringUtils.isNotBlank((CharSequence)items[3]) && credential instanceof YopSymmetricCredentials) {
            String encryptedCredentialStr = items[3];
            parsedEncryptOptions.setEncryptedCredentials(encryptedCredentialStr);
            try {
                byte[] encryptedCredentialBytes = Encodes.decodeBase64(encryptedCredentialStr);
                byte[] decryptedSecretKey = YopEncryptorFactory.getEncryptor(credentialsAlg).decrypt(encryptedCredentialBytes, new EncryptOptions(yopCredentials));
                if (null != decryptedSecretKey) {
                    credential = new YopSymmetricCredentials(yopCredentials.getAppKey(), Encodes.encodeUrlSafeBase64(decryptedSecretKey));
                    parsedEncryptOptions.setCredentials(credential);
                }
            }
            catch (Exception e) {
                LOGGER.warn("error when decrypt work credential with appKey:" + yopCredentials.getAppKey() + ", ex:", (Throwable)e);
            }
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(YopEncryptProtocol.class);
        protocolMap = Maps.newHashMap();
        for (YopEncryptProtocol protocol : YopEncryptProtocol.values()) {
            protocolMap.put(protocol.protocolPrefix, protocol);
        }
    }

    public static class ParseParams {
        private String yopEncrypt;
        private YopCredentials<?> yopCredentials;
        private EncryptOptions srcEncryptOptions;

        public ParseParams(String yopEncrypt, YopCredentials<?> yopCredentials, EncryptOptions srcEncryptOptions) {
            this.yopEncrypt = yopEncrypt;
            this.yopCredentials = yopCredentials;
            this.srcEncryptOptions = srcEncryptOptions;
        }

        public String getYopEncrypt() {
            return this.yopEncrypt;
        }

        public YopCredentials<?> getYopCredentials() {
            return this.yopCredentials;
        }

        public EncryptOptions getSrcEncryptOptions() {
            return this.srcEncryptOptions;
        }
    }

    public static class Inst {
        private EncryptOptions encryptOptions;
        private Set<String> encryptHeaders;
        private Set<String> encryptParams;

        public Inst(EncryptOptions encryptOptions) {
            this.encryptOptions = encryptOptions;
        }

        public Inst(EncryptOptions encryptOptions, Set<String> encryptHeaders, Set<String> encryptParams) {
            this.encryptOptions = encryptOptions;
            this.encryptHeaders = encryptHeaders;
            this.encryptParams = encryptParams;
        }

        public EncryptOptions getEncryptOptions() {
            return this.encryptOptions;
        }

        public Set<String> getEncryptHeaders() {
            return this.encryptHeaders;
        }

        public Set<String> getEncryptParams() {
            return this.encryptParams;
        }
    }
}

