/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yeepay.yop.sdk.base.config.provider.YopSdkConfigProviderRegistry;
import com.yeepay.yop.sdk.client.metric.YopFailureItem;
import com.yeepay.yop.sdk.client.metric.YopFailureList;
import com.yeepay.yop.sdk.client.metric.YopStatus;
import com.yeepay.yop.sdk.client.metric.event.host.YopHostRequestEvent;
import com.yeepay.yop.sdk.client.metric.report.AbstractYopReport;
import com.yeepay.yop.sdk.client.metric.report.YopRemoteReporter;
import com.yeepay.yop.sdk.client.metric.report.YopReport;
import com.yeepay.yop.sdk.client.metric.report.YopReporter;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostRequestPayload;
import com.yeepay.yop.sdk.client.metric.report.host.YopHostRequestReport;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.file.YopReportConfig;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientReporter.class);
    private static final YopReporter REMOTE_REPORTER = YopRemoteReporter.INSTANCE;
    private static final Map<String, Map<String, AtomicReference<YopHostRequestReport>>> YOP_HOST_REQUEST_COLLECTION_MAP = new ConcurrentHashMap<String, Map<String, AtomicReference<YopHostRequestReport>>>();
    private static final Map<String, Thread> DAEMON_THREADS = new ConcurrentHashMap<String, Thread>();
    private static final Set<String> EXCLUDE_REPORT_RESOURCES = Sets.newHashSet((Object[])new String[]{"/rest/v1.0/yop/client/report"});
    private static final Map<String, Deque<YopReport>> YOP_HOST_REQUEST_QUEUE_MAP = new ConcurrentHashMap<String, Deque<YopReport>>();
    private static final ThreadPoolExecutor COLLECT_POOL;
    private static volatile boolean CLOSED;

    private ClientReporter() {
    }

    private static YopReportConfig getReportConfig(String provider, String env) {
        YopReportConfig yopReportConfig;
        YopSdkConfig sdkConfig = YopSdkConfigProviderRegistry.getProvider().getConfig(provider, env);
        if (null != sdkConfig && null != (yopReportConfig = sdkConfig.getYopReportConfig())) {
            return yopReportConfig;
        }
        return YopReportConfig.DEFAULT_YOP_REPORT_CONFIG;
    }

    private static void startSenderThread(final String provider, final String env) {
        String threadName = ClientReporter.getThreadName("client-report-sender", provider, env);
        DAEMON_THREADS.computeIfAbsent(threadName, p -> {
            Thread reportSendThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!CLOSED) {
                        try {
                            ClientReporter.sendHostReport(provider, env);
                        }
                        catch (Throwable t) {
                            LOGGER.error("Unexpected Error, ex:", t);
                        }
                        try {
                            Thread.sleep(ClientReporter.getReportConfig(provider, env).getSendIntervalMs());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            reportSendThread.setName(threadName);
            reportSendThread.setDaemon(true);
            reportSendThread.start();
            return reportSendThread;
        });
    }

    private static String getThreadName(String prefix, String provider, String env) {
        return prefix + (StringUtils.isNotBlank((CharSequence)provider) ? "-" + provider : "") + (StringUtils.isNotBlank((CharSequence)env) ? "-" + env : "");
    }

    private static void startSweeperThread(final String provider, final String env) {
        String threadName = ClientReporter.getThreadName("client-report-sweeper", provider, env);
        DAEMON_THREADS.computeIfAbsent(threadName, p -> {
            Thread reportSweeperThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!CLOSED) {
                        try {
                            ClientReporter.sweepReports(provider, env);
                        }
                        catch (Throwable t) {
                            LOGGER.error("Unexpected Error, ex:", t);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            reportSweeperThread.setName(threadName);
            reportSweeperThread.setDaemon(true);
            reportSweeperThread.start();
            return reportSweeperThread;
        });
    }

    private static void sweepReports(String provider, String env) {
        Map requestCollections = YOP_HOST_REQUEST_COLLECTION_MAP.computeIfAbsent(ClientReporter.getMapKey(provider, env), p -> new ConcurrentHashMap());
        Set collectReports = requestCollections.keySet();
        if (CollectionUtils.isEmpty(collectReports)) {
            return;
        }
        for (String reportKey : collectReports) {
            AtomicReference collectReport = (AtomicReference)requestCollections.get(reportKey);
            if (null == collectReport) continue;
            ClientReporter.checkAndReport(reportKey, (YopHostRequestReport)collectReport.get(), requestCollections);
        }
    }

    private static Map<String, AtomicReference<YopHostRequestReport>> currentReportCollection(String provider, String env) {
        return YOP_HOST_REQUEST_COLLECTION_MAP.computeIfAbsent(ClientReporter.getMapKey(provider, env), p -> new ConcurrentHashMap());
    }

    private static String getMapKey(String provider, String env) {
        return provider + ":" + env;
    }

    private static void checkAndReport(String reportKey, YopHostRequestReport yopHostRequestReport, Map<String, AtomicReference<YopHostRequestReport>> requestCollections) {
        AtomicReference<YopHostRequestReport> removed;
        AbstractYopReport reportToBeQueue = null;
        if (ClientReporter.needReport(new Date(), yopHostRequestReport) && null != (removed = requestCollections.remove(reportKey))) {
            reportToBeQueue = removed.get();
        }
        if (null != reportToBeQueue) {
            reportToBeQueue.setEndDate(new Date());
            ClientReporter.syncReportToQueue(reportToBeQueue);
        }
    }

    public static void syncReportToQueue(YopReport report) {
        if (ClientReporter.shouldIgnoreTheReport(report)) {
            return;
        }
        Deque<YopReport> yopReportsQueue = ClientReporter.currentReportQueue(report.getProvider(), report.getEnv());
        while (!yopReportsQueue.offer(report)) {
            YopReport oldReport = yopReportsQueue.poll();
            if (oldReport == null) continue;
            LOGGER.info("Discard Old ReportEvent, value:{}", (Object)oldReport);
        }
    }

    private static Deque<YopReport> currentReportQueue(String provider, String env) {
        return YOP_HOST_REQUEST_QUEUE_MAP.computeIfAbsent(ClientReporter.getMapKey(provider, env), p -> new LinkedBlockingDeque(ClientReporter.getReportConfig(provider, env).getMaxQueueSize()));
    }

    public static void asyncReportToQueue(YopReport report) {
        if (ClientReporter.shouldIgnoreTheReport(report)) {
            return;
        }
        COLLECT_POOL.submit(() -> ClientReporter.syncReportToQueue(report));
    }

    private static boolean shouldIgnoreTheReport(YopReport report) {
        if (CLOSED || null == report || !ClientReporter.getReportConfig(report.getProvider(), report.getEnv()).isEnable()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore ReportEvent, value:{}", (Object)report);
            }
            return true;
        }
        return false;
    }

    public static void asyncReportToQueue(YopReport report, ThreadPoolExecutor executor) {
        if (ClientReporter.shouldIgnoreTheReport(report)) {
            return;
        }
        executor.submit(() -> ClientReporter.syncReportToQueue(report));
    }

    public static void reportHostRequest(YopHostRequestEvent<?> newEvent) {
        try {
            if (CLOSED || null == newEvent) {
                return;
            }
            YopReportConfig reportConfig = ClientReporter.getReportConfig(newEvent.getProvider(), newEvent.getEnv());
            if (!reportConfig.isEnable()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignore ReportEvent, value:{}", newEvent);
                }
                return;
            }
            if (!reportConfig.isEnableSuccessReport() && YopStatus.SUCCESS.equals((Object)newEvent.getStatus())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignore Success ReportEvent, value:{}", newEvent);
                }
                return;
            }
            if (StringUtils.isBlank((CharSequence)newEvent.getServerResource()) || EXCLUDE_REPORT_RESOURCES.contains(newEvent.getServerResource()) || null != reportConfig.getExcludeResources() && reportConfig.getExcludeResources().contains(newEvent.getServerResource())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignore ReportEvent For Resource Excluded, value:{}", newEvent);
                }
                return;
            }
            ClientReporter.collectEvents(newEvent);
        }
        catch (Exception exception) {
            LOGGER.error("Error Handle ReportEvent, value:" + newEvent, (Throwable)exception);
        }
    }

    private static void collectEvents(YopHostRequestEvent<?> event) {
        String provider = event.getProvider();
        String env = event.getEnv();
        ClientReporter.startSweeperThread(provider, env);
        ClientReporter.startSenderThread(provider, env);
        COLLECT_POOL.submit(new CollectTask(event));
    }

    private static void sendHostReport(String provider, String env) throws InterruptedException {
        YopReport report;
        Deque<YopReport> yopReportsQueue = ClientReporter.currentReportQueue(provider, env);
        LinkedList<YopReport> reports = new LinkedList<YopReport>();
        while (null != (report = yopReportsQueue.poll())) {
            reports.add(report);
            if (reports.size() < ClientReporter.getReportConfig(provider, env).getMaxPacketSize()) continue;
            ClientReporter.sendWithRetry(provider, env, reports);
            reports = new LinkedList();
        }
        if (CollectionUtils.isNotEmpty(reports)) {
            ClientReporter.sendWithRetry(provider, env, reports);
        }
    }

    private static void sendWithRetry(String provider, String env, List<YopReport> reports) {
        try {
            REMOTE_REPORTER.batchReport(provider, env, reports);
        }
        catch (Exception ex) {
            LOGGER.warn("Remote Report Fail, exType:{}, exMsg:{}, But Will Retry.", (Object)ex.getClass().getCanonicalName(), (Object)StringUtils.defaultString((String)ex.getMessage()));
            ClientReporter.tryEnqueue(provider, env, reports);
        }
    }

    private static void tryEnqueue(String provider, String env, List<YopReport> reports) {
        if (CollectionUtils.isEmpty(reports)) {
            return;
        }
        for (int i = reports.size() - 1; i >= 0; --i) {
            try {
                ClientReporter.currentReportQueue(provider, env).push(reports.get(i));
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn("Report ReEnqueue Fail, exType:{}, exMsg:{}, ", (Object)ex.getClass().getCanonicalName(), (Object)StringUtils.defaultString((String)ex.getMessage()));
            }
        }
    }

    private static boolean needReport(Date currentTime, YopHostRequestReport report) {
        if (null == report) {
            return false;
        }
        YopReportConfig reportConfig = ClientReporter.getReportConfig(report.getProvider(), report.getEnv());
        YopHostRequestPayload payload = report.getPayload();
        Date beginTime = report.getBeginDate();
        int failCount = payload.getFailCount();
        long maxElapsedMillis = payload.getMaxElapsedMillis();
        List<YopFailureList> failDetails = payload.getFailDetails();
        if (currentTime.getTime() - beginTime.getTime() >= (long)reportConfig.getStatIntervalMs()) {
            return true;
        }
        if (failCount >= reportConfig.getMaxFailCount()) {
            return true;
        }
        if (maxElapsedMillis >= (long)reportConfig.getMaxElapsedMs()) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(failDetails)) {
            for (YopFailureList failDetail : failDetails) {
                if (CollectionUtils.size(failDetail.getOccurDate()) < reportConfig.getMaxFailCountPerEx()) continue;
                return true;
            }
        }
        return false;
    }

    public static void close() {
        try {
            CLOSED = true;
        }
        catch (Exception exception) {
            LOGGER.error("Error When Close ClientReporter", (Throwable)exception);
        }
    }

    public static void open() {
        try {
            CLOSED = false;
        }
        catch (Exception exception) {
            LOGGER.error("Error When Open ClientReporter", (Throwable)exception);
        }
    }

    static {
        CLOSED = false;
        COLLECT_POOL = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, Queues.newLinkedBlockingQueue((int)500), new ThreadFactoryBuilder().setNameFormat("client-report-event-collector-%d").setDaemon(true).build(), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    private static class CollectTask
    implements Runnable {
        private final YopHostRequestEvent<?> event;

        public CollectTask(YopHostRequestEvent<?> event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                YopHostRequestReport current;
                String provider = this.event.getProvider();
                String env = this.event.getEnv();
                String appKey = this.event.getAppKey();
                String serverHost = this.event.getServerHost();
                String serverIp = this.event.getServerIp();
                long elapsedMillis = this.event.getElapsedMillis();
                int successCount = 0;
                int retrySuccessCount = 0;
                int failCount = 0;
                YopFailureItem failDetail = null;
                if (YopStatus.SUCCESS.equals((Object)this.event.getStatus())) {
                    successCount = 1;
                    if (this.event.isRetry()) {
                        retrySuccessCount = 1;
                    }
                } else {
                    failCount = 1;
                    failDetail = (YopFailureItem)this.event.getData();
                }
                Map currentReportCollection = ClientReporter.currentReportCollection(provider, env);
                String reportKey = StringUtils.joinWith((String)":", (Object[])new Object[]{appKey, serverHost, serverIp});
                AtomicReference reportReference = currentReportCollection.computeIfAbsent(reportKey, p -> new AtomicReference());
                YopHostRequestReport update = new YopHostRequestReport();
                update.setProvider(provider);
                update.setEnv(env);
                YopHostRequestPayload payload = new YopHostRequestPayload();
                payload.setAppKey(appKey);
                payload.setServerIp(serverIp);
                payload.setServerHost(serverHost);
                update.setPayload(payload);
                do {
                    if (null == (current = (YopHostRequestReport)reportReference.get())) {
                        payload.setSuccessCount(successCount);
                        payload.setRetrySuccessCount(retrySuccessCount);
                        payload.setFailCount(failCount);
                        payload.setMinElapsedMillis(elapsedMillis);
                        payload.setMaxElapsedMillis(elapsedMillis);
                        payload.setAvgElapsedMillis(elapsedMillis);
                        payload.setFailDetails(Lists.newLinkedList());
                        if (null == failDetail) continue;
                        YopFailureList yopFailDetail = new YopFailureList(failDetail.getExType(), failDetail.getExMsg());
                        yopFailDetail.getOccurDate().add(failDetail.getOccurDate());
                        payload.getFailDetails().add(yopFailDetail);
                        continue;
                    }
                    update.setBeginDate(current.getBeginDate());
                    YopHostRequestPayload oldPayload = current.getPayload();
                    payload.setSuccessCount(oldPayload.getSuccessCount() + successCount);
                    payload.setRetrySuccessCount(oldPayload.getRetrySuccessCount() + retrySuccessCount);
                    payload.setFailCount(oldPayload.getFailCount() + failCount);
                    payload.setMinElapsedMillis(Math.min(elapsedMillis, oldPayload.getMinElapsedMillis()));
                    payload.setMaxElapsedMillis(Math.max(elapsedMillis, oldPayload.getMaxElapsedMillis()));
                    payload.setAvgElapsedMillis((oldPayload.getAvgElapsedMillis() * (long)oldPayload.getTotalCount() + elapsedMillis) / (long)(oldPayload.getTotalCount() + 1));
                    payload.setFailDetails(oldPayload.cloneFailDetails());
                    YopFailureItem failDetailItem = failDetail;
                    if (null == failDetail) continue;
                    Optional<YopFailureList> yopFailDetail = payload.getFailDetails().stream().filter(p -> StringUtils.equals((CharSequence)p.getExType(), (CharSequence)failDetailItem.getExType()) && StringUtils.equals((CharSequence)p.getExMsg(), (CharSequence)failDetailItem.getExMsg())).findAny();
                    if (yopFailDetail.isPresent()) {
                        yopFailDetail.get().getOccurDate().add(failDetailItem.getOccurDate());
                        continue;
                    }
                    YopFailureList newYopFailDetail = new YopFailureList(failDetail.getExType(), failDetail.getExMsg());
                    newYopFailDetail.getOccurDate().add(failDetail.getOccurDate());
                    payload.getFailDetails().add(newYopFailDetail);
                } while (!reportReference.compareAndSet(current, update));
                ClientReporter.checkAndReport(reportKey, (YopHostRequestReport)reportReference.get(), currentReportCollection);
            }
            catch (Exception e) {
                LOGGER.warn("Error Collect ReportEvent, value:" + this.event, (Throwable)e);
            }
        }
    }
}

