/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.metric.report;

import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.cache.YopCredentialsCache;
import com.yeepay.yop.sdk.client.cmd.YopCmdExecutorRegistry;
import com.yeepay.yop.sdk.client.metric.report.YopLocalReporter;
import com.yeepay.yop.sdk.client.metric.report.YopReport;
import com.yeepay.yop.sdk.client.metric.report.YopReportException;
import com.yeepay.yop.sdk.client.metric.report.YopReporter;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.model.report.YopReportRequest;
import com.yeepay.yop.sdk.model.report.YopReportResponse;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import com.yeepay.yop.sdk.service.common.response.YopResponse;
import com.yeepay.yop.sdk.utils.ClientUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopRemoteReporter
implements YopReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopRemoteReporter.class);
    public static final YopRemoteReporter INSTANCE = new YopRemoteReporter();
    private static final YopReporter BACKUP_REPORTER = YopLocalReporter.INSTANCE;

    @Override
    public void report(YopReport report) throws YopReportException {
        this.batchReport("", "", Lists.newArrayList((Object[])new YopReport[]{report}));
    }

    private void doRemoteReport(String provider, String env, YopRequest request, List<YopReport> reports) throws YopReportException {
        try {
            YopReportRequest reportRequest = new YopReportRequest();
            reportRequest.setReports(reports);
            request.setContent(JsonUtils.toJsonString(reportRequest));
            YopResponse response = ClientUtils.getAvailableYopClient(provider, env).request(request);
            this.handleReportResponse(response);
        }
        catch (YopClientException ex) {
            LOGGER.warn("Remote Report Fail For Client Error, exType:{}, exMsg:{}", (Object)((Object)((Object)ex)).getClass().getCanonicalName(), (Object)StringUtils.defaultString((String)ex.getMessage()));
            BACKUP_REPORTER.batchReport(reports);
        }
        catch (Exception e) {
            throw new YopReportException("Remote Report Fail For Server Error, ex:", e);
        }
    }

    private YopRequest initReportRequest(String provider, String env) {
        YopRequest request = new YopRequest("/rest/v1.0/yop/client/report", "POST");
        request.getRequestConfig().setSkipVerifySign(true).setNeedEncrypt(false).setReadTimeout(60000);
        this.chooseAvailableCredentials(request, provider, env);
        return request;
    }

    private void handleReportResponse(YopResponse response) throws IOException {
        YopReportResponse reportResponse = new YopReportResponse();
        JsonUtils.load(response.getStringResult(), (Object)reportResponse);
        YopCmdExecutorRegistry.get(reportResponse.getCmdType()).execute(reportResponse.getCmd(), new Object[0]);
    }

    @Override
    public void batchReport(List<YopReport> reports) throws YopReportException {
        this.batchReport("", "", reports);
    }

    private void chooseAvailableCredentials(YopRequest request, String provider, String env) {
        YopCredentials<?> credentials;
        List<String> availableCredentials = YopCredentialsCache.listKeys(provider, env);
        if (CollectionUtils.isNotEmpty(availableCredentials) && null != (credentials = YopCredentialsCache.get(availableCredentials.get(0)))) {
            request.getRequestConfig().setAppKey(availableCredentials.get(0));
            request.getRequestConfig().setCredentials(credentials);
        }
    }

    @Override
    public void report(String provider, String env, YopReport report) throws YopReportException {
        this.batchReport(provider, env, Lists.newArrayList((Object[])new YopReport[]{report}));
    }

    @Override
    public void batchReport(String provider, String env, List<YopReport> reports) throws YopReportException {
        YopRequest request = this.initReportRequest(provider, env);
        this.doRemoteReport(provider, env, request, reports);
    }
}

