/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.client.ClientConfiguration;
import com.yeepay.yop.sdk.client.ClientReporter;
import com.yeepay.yop.sdk.client.metric.YopFailureItem;
import com.yeepay.yop.sdk.client.metric.YopStatus;
import com.yeepay.yop.sdk.client.metric.event.host.YopHostFailEvent;
import com.yeepay.yop.sdk.client.metric.event.host.YopHostRequestEvent;
import com.yeepay.yop.sdk.client.metric.event.host.YopHostSuccessEvent;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.YopHttpException;
import com.yeepay.yop.sdk.exception.YopServiceException;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.YopHttpClient;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RequestEncryptor;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.model.yos.YosDownloadResponse;
import com.yeepay.yop.sdk.utils.EnvUtils;
import com.yeepay.yop.sdk.utils.HttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractYopHttpClient
implements YopHttpClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractYopHttpClient.class);
    protected static final Set<HttpMethodName> PAYLOAD_SUPPORT_METHODS = ImmutableSet.of((Object)((Object)HttpMethodName.POST), (Object)((Object)HttpMethodName.PUT), (Object)((Object)HttpMethodName.DELETE));
    protected final ClientConfiguration clientConfig;

    public AbstractYopHttpClient(ClientConfiguration clientConfig) {
        Preconditions.checkNotNull((Object)clientConfig, (Object)"config should not be null.");
        this.clientConfig = clientConfig;
    }

    @Override
    public <Output extends BaseResponse, Input extends BaseRequest> Output execute(Request<Input> request, YopRequestConfig yopRequestConfig, ExecutionContext executionContext, HttpResponseHandler<Output> responseHandler) {
        Output analyzedResponse = null;
        YopHttpResponse httpResponse = null;
        long beginTime = System.currentTimeMillis();
        Throwable ex = null;
        try {
            this.preExecute(request, executionContext);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Signed Request: {}, elapsed:{}ms", request, (Object)(System.currentTimeMillis() - beginTime));
            }
            httpResponse = this.doExecute(request, yopRequestConfig);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received Response, elapsed:{}ms", (Object)(System.currentTimeMillis() - beginTime));
            }
            Output Output = analyzedResponse = (Output)responseHandler.handle(new HttpResponseHandleContext(httpResponse, request, executionContext));
            return Output;
        }
        catch (YopClientException | YopHttpException e) {
            ex = e;
            throw e;
        }
        catch (Exception e) {
            ex = e;
            throw new YopHttpException("Unable to execute HTTP request, requestId:" + request.getRequestId() + ", apiUri:" + request.getResourcePath() + ", serverHost:" + request.getEndpoint(), (Throwable)e);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Analyzed Response: {}, elapsed:{}ms", analyzedResponse, (Object)(System.currentTimeMillis() - beginTime));
            }
            this.postExecute(beginTime, executionContext, request, analyzedResponse, httpResponse, (Exception)ex);
        }
    }

    protected <Input extends BaseRequest, Output extends BaseResponse> void postExecute(long beginTime, ExecutionContext executionContext, Request<Input> request, Output analyzedResponse, YopHttpResponse httpResponse, Exception originEx) {
        try {
            if (!(EnvUtils.isSandBoxEnv(executionContext.getEnv()) || EnvUtils.isSandBoxMode() || EnvUtils.isSandboxApp(executionContext.getYopCredentials().getAppKey()))) {
                boolean needReport;
                boolean isEx = null != originEx;
                boolean isClientEx = originEx instanceof YopClientException;
                boolean isServiceEx = originEx instanceof YopServiceException;
                boolean isHttpEx = originEx instanceof YopHttpException;
                boolean isUnexpectedEx = isEx && !isClientEx && !isHttpEx;
                boolean isHostEx = isHttpEx || isUnexpectedEx;
                boolean bl = needReport = !isEx || isServiceEx || isHostEx;
                if (needReport) {
                    long elapsedTime = System.currentTimeMillis() - beginTime;
                    YopHostRequestEvent reportEvent = isHostEx ? this.toFailRequest(executionContext, request, httpResponse, originEx, elapsedTime) : this.toSuccessRequest(executionContext, request, httpResponse, elapsedTime);
                    ClientReporter.reportHostRequest(reportEvent);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Reported Request: {}, elapsed:{}ms", (Object)reportEvent, (Object)(System.currentTimeMillis() - beginTime));
                    }
                }
            }
            if (!(analyzedResponse instanceof YosDownloadResponse) && null != httpResponse) {
                httpResponse.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("error when postExecute, ex:", (Throwable)e);
        }
    }

    private <Input extends BaseRequest> YopHostSuccessEvent toSuccessRequest(ExecutionContext executionContext, Request<Input> request, YopHttpResponse httpResponse, long elapsedTime) {
        YopHostSuccessEvent successEvent = new YopHostSuccessEvent();
        this.setBasic(successEvent, executionContext, request, httpResponse, elapsedTime);
        successEvent.setStatus(YopStatus.SUCCESS);
        successEvent.setData("");
        return successEvent;
    }

    private <Input extends BaseRequest> YopHostFailEvent toFailRequest(ExecutionContext executionContext, Request<Input> request, YopHttpResponse httpResponse, Exception ex, long elapsedTime) {
        YopHostFailEvent failEvent = new YopHostFailEvent();
        this.setBasic(failEvent, executionContext, request, httpResponse, elapsedTime);
        failEvent.setStatus(YopStatus.FAIL);
        failEvent.setData(new YopFailureItem(ex));
        return failEvent;
    }

    private <Input extends BaseRequest> void setBasic(YopHostRequestEvent<?> event, ExecutionContext executionContext, Request<Input> request, YopHttpResponse httpResponse, long elapsedTime) {
        event.setProvider(executionContext.getProvider());
        event.setEnv(executionContext.getEnv());
        event.setAppKey(executionContext.getYopCredentials().getAppKey());
        event.setServerResource(request.getResourcePath());
        event.setServerHost(HttpUtils.generateHostHeader(request.getEndpoint()));
        String serverIp = "";
        if (null != httpResponse) {
            serverIp = httpResponse.getHeader("x-yop-server-ip");
        }
        event.setServerIp(StringUtils.defaultString((String)serverIp, (String)""));
        event.setElapsedMillis(elapsedTime);
        event.setRetry(executionContext.getRetryCount() > 0);
    }

    protected abstract <Input extends BaseRequest> YopHttpResponse doExecute(Request<Input> var1, YopRequestConfig var2) throws IOException;

    protected <Input extends BaseRequest> void preExecute(Request<Input> request, ExecutionContext executionContext) throws ExecutionException, InterruptedException, UnsupportedEncodingException {
        this.addStandardHeader(request, executionContext);
        this.encryptRequest(request, executionContext);
        this.signRequest(request, executionContext);
    }

    private <Input extends BaseRequest> void addStandardHeader(Request<Input> request, ExecutionContext executionContext) {
        request.addHeader("x-yop-appkey", executionContext.getYopCredentials().getAppKey());
        request.addHeader("User-Agent", this.clientConfig.getUserAgent());
        request.addHeader("x-yop-session-id", YopConstants.YOP_SESSION_ID);
        request.addHeader("x-yop-sdk-langs", "java");
        request.addHeader("x-yop-sdk-version", "4.4.12");
    }

    private <Input extends BaseRequest> void encryptRequest(Request<Input> request, ExecutionContext executionContext) throws ExecutionException, InterruptedException, UnsupportedEncodingException {
        if (!executionContext.isEncryptSupported()) {
            LOGGER.debug("request not encrypted\uff0cencryptor:{}, encryptOptions:{}", (Object)executionContext.getEncryptor(), executionContext.getEncryptOptions());
            return;
        }
        if (!RequestEncryptor.encrypt(executionContext.getProvider(), executionContext.getEnv(), request, executionContext.getYopCredentials().getAppKey(), executionContext.getEncryptor(), executionContext.getEncryptOptions())) {
            executionContext.setEncryptSupported(false);
        }
    }

    private <Input extends BaseRequest> void signRequest(Request<Input> request, ExecutionContext executionContext) {
        executionContext.getSigner().sign(request, executionContext.getYopCredentials(), executionContext.getSignOptions());
    }

    protected <Input extends BaseRequest> boolean checkForMultiPart(Request<Input> request) throws YopClientException {
        boolean result;
        boolean bl = result = request.getMultiPartFiles() != null && request.getMultiPartFiles().size() > 0;
        if (result && !HttpMethodName.POST.equals((Object)request.getHttpMethod())) {
            throw new YopClientException("ReqParam Illegal, ContentType:multipart/form-data only support Post Request");
        }
        return result;
    }

    protected <Input extends BaseRequest> void buildHttpHeaders(Request<Input> request, HeaderBuilder headerBuilder) {
        headerBuilder.addHeader("Host", HttpUtils.generateHostHeader(request.getEndpoint()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            headerBuilder.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public static interface HeaderBuilder {
        public void addHeader(String var1, String var2);
    }
}

