/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.MultiPartFile;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.FileParam;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultRequest<T extends BaseRequest>
implements Request<T> {
    private String requestId;
    private YopContentType contentType;
    private String resourcePath;
    private final Map<String, List<String>> parameters = Maps.newLinkedHashMap();
    private final Map<String, List<MultiPartFile>> multiPartFiles = Maps.newLinkedHashMap();
    private final Map<String, String> headers = Maps.newHashMap();
    private URI endpoint;
    private final String serviceName;
    private final T originalRequest;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;
    private int timeOffset;
    private boolean yosAssigned = false;

    public DefaultRequest(T originalRequest, String serviceName) {
        this.serviceName = serviceName;
        this.originalRequest = originalRequest;
        this.requestId = UUID.randomUUID().toString();
        this.headers.put("x-yop-request-id", this.requestId);
    }

    public DefaultRequest(String serviceName) {
        this(null, serviceName);
    }

    public DefaultRequest(T originalRequest) {
        this(originalRequest, "");
    }

    public T getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public void addHeader(String name, String value) {
        if ("x-yop-request-id".equals(name)) {
            this.requestId = value;
        }
        this.headers.put(name, value);
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public YopContentType getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(YopContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void addParameter(String name, String value) {
        ArrayList paramList = this.parameters.get(name);
        if (paramList == null) {
            paramList = Lists.newArrayList();
            this.parameters.put(name, paramList);
        }
        paramList.add(value);
    }

    @Override
    public void addParameters(String name, List<String> values) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            this.addParameter(name, value);
        }
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    @Override
    public Request<T> withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    @Override
    public Map<String, List<MultiPartFile>> getMultiPartFiles() {
        return this.multiPartFiles;
    }

    @Override
    public void setMultiPartFiles(Map<String, List<MultiPartFile>> multiPartFiles) {
        this.multiPartFiles.clear();
        this.multiPartFiles.putAll(multiPartFiles);
    }

    @Override
    public Request<T> withMultiPartFile(String name, File file) {
        this.addMultiPartFile(name, file);
        return this;
    }

    @Override
    public void addMultiPartFile(String name, File file) {
        ArrayList files = this.multiPartFiles.get(name);
        if (files == null) {
            files = Lists.newArrayList();
            this.multiPartFiles.put(name, files);
        }
        try {
            files.add(new MultiPartFile(file));
        }
        catch (Exception ex) {
            throw new YopClientException("ReqParam Illegal, FileParam, name:" + name + ", value:" + file, (Throwable)ex);
        }
    }

    @Override
    public void addMultiPartFile(String name, InputStream in) {
        ArrayList files = this.multiPartFiles.get(name);
        if (files == null) {
            files = Lists.newArrayList();
            this.multiPartFiles.put(name, files);
        }
        try {
            files.add(new MultiPartFile(in));
        }
        catch (Exception ex) {
            throw new YopClientException("ReqParam Illegal, InputStreamParam, name:" + name + ", ex:", (Throwable)ex);
        }
    }

    @Override
    public void addMultiPartFile(String name, FileParam fileParam) {
        ArrayList files = this.multiPartFiles.get(name);
        if (files == null) {
            files = Lists.newArrayList();
            this.multiPartFiles.put(name, files);
        }
        try {
            files.add(new MultiPartFile(fileParam.getFileExtName(), fileParam.getFileStream()));
        }
        catch (Exception ex) {
            throw new YopClientException("ReqParam Illegal, InputStreamParam, name:" + name + ", ex:", (Throwable)ex);
        }
    }

    @Override
    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public void setContent(InputStream content) {
        this.content = content;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    @Override
    public int getTimeOffset() {
        return this.timeOffset;
    }

    @Override
    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    @Override
    public Request<T> withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getHttpMethod()).append(" ");
        builder.append(this.getEndpoint()).append(" ");
        String resourcePath = this.getResourcePath();
        if (resourcePath == null) {
            builder.append("/");
        } else {
            if (!resourcePath.startsWith("/")) {
                builder.append("/");
            }
            builder.append(resourcePath);
        }
        builder.append(" ");
        if (!this.getParameters().isEmpty()) {
            builder.append("Parameters: (").append(JsonUtils.toJsonString(this.parameters));
        }
        if (!this.getHeaders().isEmpty()) {
            builder.append("Headers: (");
            for (String key : this.getHeaders().keySet()) {
                String value = this.getHeaders().get(key);
                builder.append(key).append(": ").append(value).append(", ");
            }
            builder.append(") ");
        }
        return builder.toString();
    }

    @Override
    public T getOriginalRequestObject() {
        return this.originalRequest;
    }

    @Override
    public boolean isYosRequest() {
        return this.yosAssigned || this.multiPartFiles != null && this.multiPartFiles.size() > 0;
    }

    @Override
    public void assignYos() {
        this.yosAssigned = true;
    }
}

