/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.base.cache.EncryptOptionsCache;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptProtocol;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.MultiPartFile;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.HttpUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestEncryptor.class);

    public static boolean encrypt(String provider, String env, Request<? extends BaseRequest> request, String appKey, YopEncryptor encryptor, Future<EncryptOptions> encryptOptionsFuture) throws UnsupportedEncodingException {
        YopRequestConfig requestConfig = request.getOriginalRequestObject().getRequestConfig();
        if (BooleanUtils.isFalse((Boolean)requestConfig.getNeedEncrypt())) {
            LOGGER.info("request not encrypted for requestConfig needEncrypt:false");
            return false;
        }
        Set<String> encryptHeaders = Collections.emptySet();
        Set<String> encryptParams = Collections.emptySet();
        EncryptOptions encryptOptions = null;
        if (BooleanUtils.isTrue((Boolean)requestConfig.getNeedEncrypt())) {
            try {
                encryptOptions = encryptOptionsFuture.get();
            }
            catch (Exception e) {
                LOGGER.warn("request not encrypted, EncryptOptions InitFail, ex:", (Throwable)e);
                EncryptOptionsCache.invalidateEncryptOptions(provider, env, appKey, requestConfig.getEncryptAlg(), requestConfig.getServerRoot());
                return false;
            }
            encryptHeaders = RequestEncryptor.encryptHeaders(encryptor, requestConfig.getEncryptHeaders(), request, encryptOptions);
            encryptParams = RequestEncryptor.encryptParams(encryptor, requestConfig.getEncryptParams(), request, requestConfig, encryptOptions);
        }
        if (null == encryptOptions || CollectionUtils.isEmpty(encryptHeaders) && CollectionUtils.isEmpty(encryptParams)) {
            LOGGER.info("request not encrypted for requestConfig headers:{}, params:{}", requestConfig.getEncryptHeaders(), requestConfig.getEncryptParams());
            return false;
        }
        RequestEncryptor.buildEncryptHeader(request, encryptHeaders, encryptParams, encryptOptions);
        return true;
    }

    public static String buildEncryptHeader(Request<? extends BaseRequest> request, Set<String> encryptHeaders, Set<String> encryptParams, EncryptOptions encryptOptions) throws UnsupportedEncodingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("request encrypted, requestId:{}, headers:{}, params:{}", new Object[]{request.getRequestId(), encryptHeaders, encryptParams});
        }
        String encryptHeader = YopEncryptProtocol.YOP_ENCRYPT_PROTOCOL_V1_REQ.getProtocolPrefix() + "/" + RequestEncryptor.getPlatformCertSerialNo(encryptOptions) + "/" + StringUtils.replace((String)encryptOptions.getAlg(), (String)"/", (String)"_") + "/" + encryptOptions.getEncryptedCredentials() + "/" + RequestEncryptor.getIvAAD(encryptOptions) + "/" + encryptOptions.getBigParamEncryptMode() + "/" + StringUtils.join(encryptHeaders, (String)";") + "/" + Encodes.encodeUrlSafeBase64(StringUtils.join(encryptParams, (String)";").getBytes("UTF-8"));
        LOGGER.debug("encryptHeader:{}", (Object)encryptHeader);
        request.addHeader("x-yop-encrypt", encryptHeader);
        return encryptHeader;
    }

    private static String getPlatformCertSerialNo(EncryptOptions encryptOptions) {
        String platformSerialNo = (String)encryptOptions.getEnhancerInfo().get("YOP_PLATFORM_CERT_SERIAL_NO");
        if (StringUtils.isBlank((CharSequence)platformSerialNo) || StringUtils.equalsIgnoreCase((CharSequence)platformSerialNo, (CharSequence)"null")) {
            platformSerialNo = "";
        }
        return platformSerialNo;
    }

    private static String getIvAAD(EncryptOptions encryptOptions) {
        String iv = encryptOptions.getIv();
        String aad = encryptOptions.getAad();
        if (StringUtils.isBlank((CharSequence)iv) && StringUtils.isBlank((CharSequence)aad)) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)iv)) {
            iv = "";
        }
        if (StringUtils.isBlank((CharSequence)aad)) {
            aad = "";
        }
        return iv + ";" + aad;
    }

    private static Set<String> encryptHeaders(YopEncryptor encryptor, Set<String> encryptHeaders, Request<? extends BaseRequest> request, EncryptOptions encryptOptions) {
        if (CollectionUtils.isEmpty(encryptHeaders)) {
            return encryptHeaders;
        }
        HashSet finalEncryptHeaders = Sets.newHashSetWithExpectedSize((int)encryptHeaders.size());
        Map<String, String> headers = request.getHeaders();
        headers.forEach((k, v) -> {
            if (encryptHeaders.contains(k) && StringUtils.isNotBlank((CharSequence)v)) {
                headers.put((String)k, encryptor.encryptToBase64(v, encryptOptions));
                finalEncryptHeaders.add(k);
            }
        });
        return finalEncryptHeaders;
    }

    private static Set<String> encryptParams(YopEncryptor encryptor, Set<String> encryptParams, Request<? extends BaseRequest> request, YopRequestConfig requestConfig, EncryptOptions encryptOptions) {
        boolean totalEncrypt = BooleanUtils.isTrue((Boolean)requestConfig.getTotalEncrypt());
        if (!totalEncrypt && CollectionUtils.isEmpty(encryptParams) && null == request.getContent()) {
            return encryptParams;
        }
        HashSet finalEncryptParams = Sets.newHashSetWithExpectedSize((int)encryptParams.size());
        Map<String, List<String>> parameters = request.getParameters();
        RequestEncryptor.encryptSimpleParams(encryptor, finalEncryptParams, encryptParams, parameters, encryptOptions, totalEncrypt);
        Map<String, List<MultiPartFile>> multiPartFiles = request.getMultiPartFiles();
        RequestEncryptor.encryptMultiPartParams(encryptor, finalEncryptParams, encryptParams, multiPartFiles, encryptOptions, totalEncrypt);
        RequestEncryptor.encryptContent(encryptor, finalEncryptParams, request, requestConfig, encryptOptions);
        LOGGER.debug("encryptParams finished, totalEncrypt:{}, params:{}", (Object)totalEncrypt, (Object)finalEncryptParams);
        return totalEncrypt ? YopConstants.TOTAL_ENCRYPT_PARAMS : finalEncryptParams;
    }

    private static void encryptContent(YopEncryptor encryptor, Set<String> finalEncryptParams, Request<? extends BaseRequest> request, YopRequestConfig requestConfig, EncryptOptions encryptOptions) {
        if (null == request.getContent()) {
            return;
        }
        if (HttpUtils.isJsonContentType(request)) {
            byte[] jsonBytes = RequestEncryptor.encryptJsonParams(encryptor, finalEncryptParams, requestConfig, request.getContent(), encryptOptions);
            RestartableInputStream restartableInputStream = RestartableInputStream.wrap(jsonBytes);
            request.setContent(restartableInputStream);
            request.addHeader("Content-Length", String.valueOf(jsonBytes.length));
        } else if (YopContentType.OCTET_STREAM.equals((Object)request.getContentType())) {
            request.setContent(encryptor.encrypt(request.getContent(), encryptOptions));
            finalEncryptParams.add("$");
        } else {
            throw new YopClientException("body content is not supported, contentType:" + (Object)((Object)request.getContentType()));
        }
    }

    private static byte[] encryptJsonParams(YopEncryptor encryptor, Set<String> finalEncryptParams, YopRequestConfig requestConfig, InputStream content, EncryptOptions encryptOptions) {
        try {
            String encryptedJson;
            String originJson = IOUtils.toString((InputStream)content, (String)"UTF-8");
            Set<String> encryptPaths = null;
            boolean totalEncrypt = true;
            if (BooleanUtils.isFalse((Boolean)requestConfig.getTotalEncrypt())) {
                encryptPaths = JsonUtils.resolveAllJsonPaths(originJson, requestConfig.getEncryptParams());
                totalEncrypt = JsonUtils.isTotalEncrypt(encryptPaths);
            }
            if (!totalEncrypt) {
                DocumentContext valReadWriteCtx = JsonPath.parse((String)originJson);
                for (String encryptPath : encryptPaths) {
                    try {
                        String plainVal = JsonUtils.toJsonString(valReadWriteCtx.read(encryptPath, new Predicate[0]));
                        if (!StringUtils.isNotBlank((CharSequence)plainVal)) continue;
                        String encrypted = encryptor.encryptToBase64(plainVal, encryptOptions);
                        valReadWriteCtx.set(encryptPath, (Object)encrypted, new Predicate[0]);
                        finalEncryptParams.add(encryptPath);
                        LOGGER.debug("json request encrypted partly, path:{}, source:{}, target:{}, options:{}", new Object[]{encryptPath, plainVal, encrypted, encryptOptions});
                    }
                    catch (PathNotFoundException pathNotFoundException) {}
                }
                encryptedJson = valReadWriteCtx.jsonString();
            } else {
                finalEncryptParams.add("$");
                encryptedJson = JsonUtils.toJsonString(encryptor.encryptToBase64(originJson, encryptOptions));
            }
            LOGGER.debug("json request encrypted, source:{}, target:{}, options:{}", new Object[]{originJson, encryptedJson, encryptOptions});
            return encryptedJson.getBytes("UTF-8");
        }
        catch (IOException e) {
            throw new YopClientException("error happened when encrypt json", (Throwable)e);
        }
    }

    private static void encryptMultiPartParams(YopEncryptor encryptor, Set<String> finalEncryptParams, Set<String> encryptParams, Map<String, List<MultiPartFile>> multiPartFiles, EncryptOptions encryptOptions, boolean totalEncrypt) {
        multiPartFiles.forEach((name, list) -> {
            if (CollectionUtils.isNotEmpty((Collection)list) && (totalEncrypt || encryptParams.contains(name))) {
                ArrayList encryptedValues = Lists.newArrayListWithExpectedSize((int)list.size());
                for (MultiPartFile value : list) {
                    try {
                        encryptedValues.add(new MultiPartFile(encryptor.encrypt((InputStream)value.getInputStream(), encryptOptions), value.getFileName()));
                    }
                    catch (IOException e) {
                        throw new YopClientException("error happened when encrypt MultiPartFile", (Throwable)e);
                    }
                }
                multiPartFiles.put((String)name, encryptedValues);
                finalEncryptParams.add((String)name);
            }
        });
    }

    private static void encryptSimpleParams(YopEncryptor encryptor, Set<String> finalEncryptParams, Set<String> encryptParams, Map<String, List<String>> parameters, EncryptOptions encryptOptions, boolean totalEncrypt) {
        parameters.forEach((name, list) -> {
            if (CollectionUtils.isNotEmpty((Collection)list) && (totalEncrypt || encryptParams.contains(name))) {
                ArrayList encryptedValues = Lists.newArrayListWithExpectedSize((int)list.size());
                for (String value : list) {
                    encryptedValues.add(encryptor.encryptToBase64(value, encryptOptions));
                }
                parameters.put((String)name, encryptedValues);
                finalEncryptParams.add((String)name);
            }
        });
    }
}

