/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.callback.protocol;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.service.common.callback.YopCallbackRequest;
import com.yeepay.yop.sdk.service.common.callback.protocol.YopCallbackProtocol;
import com.yeepay.yop.sdk.service.common.callback.protocol.YopRsaCallbackProtocol;
import com.yeepay.yop.sdk.service.common.callback.protocol.YopSm2CallbackProtocol;
import com.yeepay.yop.sdk.service.common.callback.protocol.YopSm4CallbackProtocol;
import com.yeepay.yop.sdk.utils.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopCallbackProtocolFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopCallbackProtocolFactory.class);

    public static YopCallbackProtocol fromRequest(YopCallbackRequest request) {
        String authorization;
        Map<String, String> headers;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to build YopCallbackProtocol, request:{}", (Object)request);
        }
        if (MapUtils.isNotEmpty(headers = request.getCanonicalHeaders()) && StringUtils.isNotBlank((CharSequence)(authorization = headers.get("Authorization".toLowerCase()))) && authorization.startsWith("YOP-SM2-SM3")) {
            return new YopSm2CallbackProtocol(request);
        }
        return YopCallbackProtocolFactory.deprecatedProtocol(request);
    }

    @Deprecated
    private static YopCallbackProtocol deprecatedProtocol(YopCallbackRequest request) {
        Map params;
        switch (request.getContentType()) {
            case JSON: {
                String json = (String)request.getContent();
                params = JsonUtils.fromJsonString(json, Map.class);
                break;
            }
            case FORM_URL_ENCODE: {
                params = YopCallbackProtocolFactory.toParams(request.getParams());
                break;
            }
            default: {
                throw new YopClientException("unsupported content Type for YopCallback, type:" + (Object)((Object)request.getContentType()));
            }
        }
        String appKey = params.get("customerIdentification");
        String algorithm = (String)params.get("algorithm");
        if (StringUtils.equals((CharSequence)algorithm, (CharSequence)"AEAD_SM4_GCM")) {
            return new YopSm4CallbackProtocol().setCustomerIdentification(appKey).setAlgorithm(algorithm).setCertType(CertTypeEnum.SM4).setAssociatedData((String)params.get("associatedData")).setNonce((String)params.get("nonce")).setCipherText((String)params.get("cipherText")).setOriginRequest(request);
        }
        return new YopRsaCallbackProtocol().setCustomerIdentification(appKey).setResponse((String)params.get("response")).setOriginRequest(request);
    }

    private static Map<String, String> toParams(Map<String, List<String>> params) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)params.size());
        for (Map.Entry<String, List<String>> param : params.entrySet()) {
            result.put(param.getKey(), CollectionUtils.isNotEmpty((Collection)param.getValue()) ? param.getValue().get(0) : null);
        }
        return result;
    }
}

