/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.callback.protocol;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.base.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptProtocol;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.protocol.AuthenticateProtocolVersion;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.service.common.callback.YopCallback;
import com.yeepay.yop.sdk.service.common.callback.YopCallbackRequest;
import com.yeepay.yop.sdk.service.common.callback.protocol.AbstractYopCallbackProtocol;
import com.yeepay.yop.sdk.utils.HttpUtils;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSm2CallbackProtocol
extends AbstractYopCallbackProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSm2CallbackProtocol.class);
    private static final Splitter SIGNED_HEADER_STRING_SPLITTER = Splitter.on((String)";");
    private static final Joiner HEADER_JOINER = Joiner.on((String)"\n");
    private String yopRequestId;
    private CertTypeEnum certType;
    private DigestAlgEnum digestAlgEnum;
    private AuthenticateProtocolVersion protocolVersion;
    private String appKey;
    private String timestamp;
    private long expirationInSeconds;
    private String signedHeaders;
    private String signature;
    private String platformSerialNo;
    private String platformServerRoot;
    private String yopEncrypt;

    public YopSm2CallbackProtocol(YopCallbackRequest request) {
        this.initialize(request);
        this.originRequest = request;
    }

    @Override
    public YopCallback parse() {
        this.verifySign(this.platformServerRoot);
        String bizContent = this.decryptBizContent();
        return YopCallback.builder().withId(this.yopRequestId).withAppKey(this.appKey).withType(this.originRequest.getHttpPath()).withCreateTime(new Date()).withBizData(bizContent).withMetaInfo("headers", this.originRequest.getHeaders()).build();
    }

    private void verifySign(String serverRoot) {
        String sign = this.signature;
        String[] args = sign.split("\\$");
        String plainText = this.preparePlainText();
        YopPlatformCredentials platformCredentials = YopPlatformCredentialsProviderRegistry.getProvider().getCredentials(this.originRequest.getProvider(), this.originRequest.getEnv(), this.appKey, this.platformSerialNo, serverRoot);
        YopSignProcessorFactory.getSignProcessor(this.certType.getValue()).verify(plainText, args[0], (CredentialsItem)platformCredentials.getCredential());
    }

    private String decryptBizContent() {
        YopCredentials yopCredentials = YopCredentialsProviderRegistry.getProvider().getCredentials(this.originRequest.getProvider(), this.originRequest.getEnv(), this.appKey, this.certType.getValue());
        EncryptOptions templateOptions = new EncryptOptions();
        templateOptions.setCredentials((Object)new YopSymmetricCredentials(this.appKey, ""));
        templateOptions.setCredentialsAlg(this.certType.getValue());
        YopEncryptProtocol.Inst parsedEncryptProtocol = this.parseEncryptProtocol(this.yopEncrypt, yopCredentials, templateOptions);
        if (null == parsedEncryptProtocol) {
            throw new YopClientException("illegal YopSm2CallbackProtocol, request:" + this.originRequest);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("YopSm2CallbackProtocol to be Decrypted, requestId:{}, headers:{}, params:{}", new Object[]{this.yopRequestId, parsedEncryptProtocol.getEncryptHeaders(), parsedEncryptProtocol.getEncryptParams()});
        }
        EncryptOptions encryptOptions = parsedEncryptProtocol.getEncryptOptions();
        YopEncryptor encryptor = YopEncryptorFactory.getEncryptor(encryptOptions.getAlg());
        if (null == this.originRequest.getContent()) {
            return "";
        }
        return encryptor.decryptFromBase64((String)this.originRequest.getContent(), encryptOptions);
    }

    private void initialize(YopCallbackRequest request) {
        try {
            Map<String, String> headers = request.getCanonicalHeaders();
            String authorization = headers.get("Authorization".toLowerCase());
            String[] protocol = authorization.split(" ");
            String protocolPrefix = protocol[0];
            String protocolContent = protocol[1];
            String[] parts = protocolPrefix.split("-");
            this.certType = CertTypeEnum.parse((String)parts[1]);
            this.digestAlgEnum = DigestAlgEnum.valueOf((String)parts[2]);
            String[] authorizationHeaders = StringUtils.split((String)protocolContent, (String)"/");
            this.protocolVersion = AuthenticateProtocolVersion.parse(authorizationHeaders[0]);
            this.appKey = authorizationHeaders[1];
            this.timestamp = authorizationHeaders[2];
            this.expirationInSeconds = Long.parseLong(authorizationHeaders[3]);
            this.signedHeaders = authorizationHeaders[4].toLowerCase();
            this.signature = authorizationHeaders[5];
            this.platformSerialNo = headers.get("x-yop-sign-serial-no");
            if (StringUtils.isBlank((CharSequence)this.platformSerialNo)) {
                this.platformSerialNo = headers.get("x-yop-serial-no");
            }
            this.platformSerialNo = X509CertUtils.parseToHex(this.platformSerialNo);
            this.platformServerRoot = request.getPlatformServerRoot();
            this.yopEncrypt = headers.get("x-yop-encrypt");
            this.yopRequestId = headers.get("x-yop-request-id");
        }
        catch (Exception e) {
            throw new YopClientException("error initialize YopSm2CallbackProtocol, ex:", (Throwable)e);
        }
    }

    private String preparePlainText() {
        YopCallbackRequest req = this.originRequest;
        String authString = this.protocolVersion.stringFormat() + "/" + this.appKey + "/" + this.timestamp + "/" + this.expirationInSeconds;
        String canonicalURI = HttpUtils.getCanonicalURIPath(req.getHttpPath());
        String canonicalQueryString = this.getCanonicalQueryString();
        String canonicalHeader = this.getCanonicalHeaders();
        return authString + "\n" + req.getHttpPath() + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalHeader;
    }

    private String getCanonicalQueryString() {
        if (HttpUtils.useEmptyAsCanonicalQueryString(this.originRequest.getHttpMethod(), this.originRequest.getContentType())) {
            return "";
        }
        return HttpUtils.getCanonicalQueryString(this.originRequest.getParams(), true);
    }

    private String getCanonicalHeaders() {
        YopCallbackRequest req = this.originRequest;
        HashSet headerNames = Sets.newHashSet((Iterable)SIGNED_HEADER_STRING_SPLITTER.split((CharSequence)this.signedHeaders));
        ArrayList kvs = Lists.newArrayList();
        for (String key : headerNames) {
            String canonicalKey = key.trim().toLowerCase();
            String value = req.getCanonicalHeaders().get(canonicalKey);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            kvs.add(HttpUtils.normalize(canonicalKey + ":" + HttpUtils.normalize(value.trim())));
        }
        Collections.sort(kvs);
        return HEADER_JOINER.join((Iterable)kvs);
    }

    private YopEncryptProtocol.Inst parseEncryptProtocol(String encryptProtocol, YopCredentials<?> yopCredentials, EncryptOptions encryptOptions) {
        if (StringUtils.isNotBlank((CharSequence)encryptProtocol)) {
            return YopEncryptProtocol.fromProtocol(encryptProtocol).parse(new YopEncryptProtocol.ParseParams(encryptProtocol, yopCredentials, encryptOptions));
        }
        return null;
    }
}

