/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.invoke;

import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.YopUnknownException;
import com.yeepay.yop.sdk.invoke.Invoker;
import com.yeepay.yop.sdk.invoke.Router;
import com.yeepay.yop.sdk.invoke.UriResourceRouteInvoker;
import com.yeepay.yop.sdk.invoke.model.AnalyzedException;
import com.yeepay.yop.sdk.invoke.model.RetryContext;
import com.yeepay.yop.sdk.invoke.model.RetryPolicy;
import com.yeepay.yop.sdk.invoke.model.UriResource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriResourceRouteInvokerWrapper<Input, Output, Context extends RetryContext, Policy extends RetryPolicy, Exception extends AnalyzedException>
implements Invoker<Input, Output, Context, Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriResourceRouteInvokerWrapper.class);
    private UriResourceRouteInvoker<Input, Output, Context, Exception> invoker;
    private RetryPolicy retryPolicy;
    private Router<UriResource, Input, Context> uriRouter;

    public UriResourceRouteInvokerWrapper(UriResourceRouteInvoker<Input, Output, Context, Exception> invoker, RetryPolicy retryPolicy, Router<UriResource, Input, Context> uriRouter) {
        this.invoker = invoker;
        this.retryPolicy = retryPolicy;
        this.uriRouter = uriRouter;
    }

    public Output invoke() {
        long start = System.currentTimeMillis();
        ArrayList excludeServerRoots = Lists.newArrayList();
        UriResource lastServerRoot = null;
        while (true) {
            try {
                lastServerRoot = (UriResource)this.uriRouter.route(this.getInput(), this.getContext(), new Object[]{excludeServerRoots});
                this.invoker.setUriResource(lastServerRoot);
                Object result = this.invoker.invoke();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Success ServerRoot, {}, elapsed:{}, retryCount:{}", new Object[]{lastServerRoot, System.currentTimeMillis() - start, this.getContext().retryCount()});
                }
                return (Output)result;
            }
            catch (Throwable throwable) {
                boolean needRetry;
                Throwable currentEx = throwable;
                if (null == lastServerRoot || null == lastServerRoot.getResource()) {
                    throw new YopClientException("Config Error, No ServerRoot Found", throwable);
                }
                if (throwable instanceof YopClientException) {
                    throw (YopClientException)throwable;
                }
                Exception analyzedException = this.getLastException();
                if (null == analyzedException) {
                    throw this.handleUnExpectedError(currentEx);
                }
                boolean bl = needRetry = analyzedException.isNeedRetry() && null != this.retryPolicy && this.retryPolicy.allowRetry(new Object[]{this});
                if (needRetry) {
                    excludeServerRoots.add(lastServerRoot.getResource());
                    if (!analyzedException.isBlocked()) {
                        this.getContext().markRetried(new Object[]{1});
                    }
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Fail ServerRoot, {}, exDetail:{}, elapsed:{}, needRetry:{}", new Object[]{lastServerRoot, ExceptionUtils.getMessage((Throwable)currentEx), System.currentTimeMillis() - start, needRetry});
                if (needRetry) continue;
                throw this.handleUnExpectedError(currentEx);
            }
            break;
        }
    }

    private RuntimeException handleUnExpectedError(Throwable ex) {
        if (ex instanceof YopUnknownException) {
            return (YopUnknownException)ex;
        }
        return new YopUnknownException("UnExpected Error, ", ex);
    }

    public Input getInput() {
        return (Input)this.invoker.getInput();
    }

    public void setInput(Input input) {
        this.invoker.setInput(input);
    }

    public void setContext(Context context) {
        this.invoker.setContext(context);
    }

    public Context getContext() {
        return (Context)((RetryContext)this.invoker.getContext());
    }

    public List<Exception> getExceptions() {
        return this.invoker.getExceptions();
    }

    public void addException(Exception exception) {
        this.invoker.addException(exception);
    }

    public Exception getLastException() {
        return (Exception)this.invoker.getLastException();
    }
}

