/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye;

import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.EagleEye;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.EagleEyeAppender;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class EagleEyeLogDaemon
implements Runnable {
    private static final long LOG_CHECK_INTERVAL = TimeUnit.SECONDS.toMillis(20L);
    private static AtomicBoolean running = new AtomicBoolean(false);
    private static Thread worker = null;
    private static final CopyOnWriteArrayList<EagleEyeAppender> watchedAppenders = new CopyOnWriteArrayList();

    static EagleEyeAppender watch(EagleEyeAppender appender) {
        watchedAppenders.addIfAbsent(appender);
        return appender;
    }

    static boolean unwatch(EagleEyeAppender appender) {
        return watchedAppenders.remove(appender);
    }

    @Override
    public void run() {
        while (running.get()) {
            this.cleanupFiles();
            try {
                Thread.sleep(LOG_CHECK_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.flushAndReload();
        }
    }

    private void cleanupFiles() {
        for (EagleEyeAppender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.cleanup();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to cleanup: " + watchedAppender, e);
            }
        }
        try {
            EagleEye.selfAppender.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void flushAndReload() {
        for (EagleEyeAppender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.reload();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to reload: " + watchedAppender, e);
            }
        }
        try {
            EagleEye.selfAppender.reload();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void start() {
        if (running.compareAndSet(false, true)) {
            Thread worker = new Thread(new EagleEyeLogDaemon());
            worker.setDaemon(true);
            worker.setName("EagleEye-LogDaemon-Thread");
            worker.start();
            EagleEyeLogDaemon.worker = worker;
        }
    }

    static void stop() {
        if (running.compareAndSet(true, false)) {
            EagleEyeLogDaemon.closeAppenders();
            Thread worker = EagleEyeLogDaemon.worker;
            if (worker != null) {
                try {
                    worker.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    worker.join(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void closeAppenders() {
        for (EagleEyeAppender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.close();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to close: " + watchedAppender, e);
            }
        }
    }

    static void flushAndWait() {
        for (EagleEyeAppender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.flush();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to flush: " + watchedAppender, e);
            }
        }
    }

    private EagleEyeLogDaemon() {
    }
}

