/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye;

import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.EagleEyeAppender;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.StatEntry;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.StatRollingData;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class StatLogger {
    private final String loggerName;
    private final EagleEyeAppender appender;
    private final AtomicReference<StatRollingData> ref;
    private final long intervalMillis;
    private final int maxEntryCount;
    private final char entryDelimiter;
    private final char keyDelimiter;
    private final char valueDelimiter;

    StatLogger(String loggerName, EagleEyeAppender appender, long intervalMillis, int maxEntryCount, char entryDelimiter, char keyDelimiter, char valueDelimiter) {
        this.loggerName = loggerName;
        this.appender = appender;
        this.intervalMillis = intervalMillis;
        this.maxEntryCount = maxEntryCount;
        this.entryDelimiter = entryDelimiter;
        this.keyDelimiter = keyDelimiter;
        this.valueDelimiter = valueDelimiter;
        this.ref = new AtomicReference();
        this.rolling();
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    EagleEyeAppender getAppender() {
        return this.appender;
    }

    StatRollingData getRollingData() {
        return this.ref.get();
    }

    long getIntervalMillis() {
        return this.intervalMillis;
    }

    int getMaxEntryCount() {
        return this.maxEntryCount;
    }

    char getEntryDelimiter() {
        return this.entryDelimiter;
    }

    char getKeyDelimiter() {
        return this.keyDelimiter;
    }

    char getValueDelimiter() {
        return this.valueDelimiter;
    }

    StatRollingData rolling() {
        long rollingTimeMillis;
        long timeSlot;
        int initialCapacity;
        StatRollingData nextData;
        StatRollingData prevData;
        do {
            long now = System.currentTimeMillis();
            timeSlot = now - now % this.intervalMillis;
        } while (!this.ref.compareAndSet(prevData = this.ref.get(), nextData = new StatRollingData(this, initialCapacity = prevData != null ? prevData.getStatCount() : 16, timeSlot, rollingTimeMillis = timeSlot + this.intervalMillis)));
        return prevData;
    }

    public StatEntry stat(String key) {
        return new StatEntry(this, key);
    }

    public StatEntry stat(String key1, String key2) {
        return new StatEntry(this, key1, key2);
    }

    public StatEntry stat(String key1, String key2, String key3) {
        return new StatEntry(this, key1, key2, key3);
    }

    public StatEntry stat(String key1, String key2, String key3, String key4) {
        return new StatEntry(this, key1, key2, key3, key4);
    }

    public StatEntry stat(String key1, String key2, String key3, String key4, String key5) {
        return new StatEntry(this, key1, key2, key3, key4, key5);
    }

    public StatEntry stat(String key1, String key2, String key3, String key4, String key5, String key6) {
        return new StatEntry(this, key1, key2, key3, key4, key5, key6);
    }

    public StatEntry stat(String key1, String key2, String key3, String key4, String key5, String key6, String key7) {
        return new StatEntry(this, key1, key2, key3, key4, key5, key6, key7);
    }

    public StatEntry stat(String key1, String key2, String key3, String key4, String key5, String key6, String key7, String key8) {
        return new StatEntry(this, key1, key2, key3, key4, key5, key6, key7, key8);
    }

    public StatEntry stat(String key1, String ... moreKeys) {
        return new StatEntry(this, key1, moreKeys);
    }

    public StatEntry stat(List<String> keys) {
        return new StatEntry(this, keys);
    }

    public StatEntry stat(String[] keys) {
        return new StatEntry(this, keys);
    }
}

