/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye;

import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.BaseLoggerBuilder;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.EagleEye;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.EagleEyeAppender;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.EagleEyeLogDaemon;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.EagleEyeRollingFileAppender;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.StatLogController;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.StatLogger;
import com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye.SyncAppender;
import java.util.concurrent.TimeUnit;

public final class StatLoggerBuilder
extends BaseLoggerBuilder<StatLoggerBuilder> {
    private int intervalSeconds = 60;
    private int maxEntryCount = 20000;
    private char keyDelimiter = (char)44;
    private char valueDelimiter = (char)44;
    private EagleEyeAppender appender = null;

    StatLoggerBuilder(String loggerName) {
        super(loggerName);
    }

    public StatLoggerBuilder intervalSeconds(int intervalSeconds) {
        StatLoggerBuilder.validateInterval(intervalSeconds);
        this.intervalSeconds = intervalSeconds;
        return this;
    }

    public StatLoggerBuilder maxEntryCount(int maxEntryCount) {
        if (maxEntryCount < 1) {
            throw new IllegalArgumentException("Max entry count should be at least 1: " + maxEntryCount);
        }
        this.maxEntryCount = maxEntryCount;
        return this;
    }

    public StatLoggerBuilder keyDelimiter(char keyDelimiter) {
        this.keyDelimiter = keyDelimiter;
        return this;
    }

    public StatLoggerBuilder valueDelimiter(char valueDelimiter) {
        this.valueDelimiter = valueDelimiter;
        return this;
    }

    StatLoggerBuilder appender(EagleEyeAppender appender) {
        this.appender = appender;
        return this;
    }

    StatLogger create() {
        long intervalMillis = TimeUnit.SECONDS.toMillis(this.intervalSeconds);
        String filePath = this.filePath == null ? EagleEye.EAGLEEYE_LOG_DIR + "stat-" + this.loggerName + ".log" : (this.filePath.endsWith("/") || this.filePath.endsWith("\\") ? this.filePath + "stat-" + this.loggerName + ".log" : this.filePath);
        EagleEyeAppender appender = this.appender;
        if (appender == null) {
            EagleEyeRollingFileAppender rfAppender = new EagleEyeRollingFileAppender(filePath, this.maxFileSize);
            appender = new SyncAppender(rfAppender);
        }
        EagleEyeLogDaemon.watch(appender);
        return new StatLogger(this.loggerName, appender, intervalMillis, this.maxEntryCount, this.entryDelimiter, this.keyDelimiter, this.valueDelimiter);
    }

    public StatLogger buildSingleton() {
        return StatLogController.createLoggerIfNotExists(this);
    }

    static void validateInterval(long intervalSeconds) throws IllegalArgumentException {
        if (intervalSeconds < 1L) {
            throw new IllegalArgumentException("Interval cannot be less than 1" + intervalSeconds);
        }
        if (intervalSeconds < 60L) {
            if (60L % intervalSeconds != 0L) {
                throw new IllegalArgumentException("Invalid second interval (cannot divide by 60): " + intervalSeconds);
            }
        } else if (intervalSeconds <= 300L) {
            if (intervalSeconds % 60L != 0L) {
                throw new IllegalArgumentException("Invalid second interval (cannot divide by 60): " + intervalSeconds);
            }
            if (60L % intervalSeconds != 0L) {
                throw new IllegalArgumentException("Invalid second interval (cannot divide by 60): " + intervalSeconds);
            }
        } else if (intervalSeconds > 300L) {
            throw new IllegalArgumentException("Interval should be less than 5 min: " + intervalSeconds);
        }
    }
}

