/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.eagleeye;

import java.util.concurrent.atomic.AtomicLong;

class TokenBucket {
    private final long maxTokens;
    private final long intervalMillis;
    private volatile long nextUpdate;
    private AtomicLong tokens;

    public TokenBucket(long maxTokens, long intervalMillis) {
        if (maxTokens <= 0L) {
            throw new IllegalArgumentException("maxTokens should > 0, but given: " + maxTokens);
        }
        if (intervalMillis < 1000L) {
            throw new IllegalArgumentException("intervalMillis should be at least 1000, but given: " + intervalMillis);
        }
        this.maxTokens = maxTokens;
        this.intervalMillis = intervalMillis;
        this.nextUpdate = System.currentTimeMillis() / 1000L * 1000L + intervalMillis;
        this.tokens = new AtomicLong(maxTokens);
    }

    public boolean accept(long now) {
        long currTokens;
        if (now > this.nextUpdate && this.tokens.compareAndSet(currTokens = this.tokens.get(), this.maxTokens)) {
            this.nextUpdate = System.currentTimeMillis() / 1000L * 1000L + this.intervalMillis;
        }
        while ((currTokens = this.tokens.get()) > 0L && !this.tokens.compareAndSet(currTokens, currTokens - 1L)) {
        }
        return currTokens > 0L;
    }
}

