/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.log;

import com.yeepay.shade.com.alibaba.csp.sentinel.util.ConfigUtil;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;

public class LogConfigLoader {
    public static final String LOG_CONFIG_ENV_KEY = "CSP_SENTINEL_CONFIG_FILE";
    public static final String LOG_CONFIG_PROPERTY_KEY = "csp.sentinel.config.file";
    private static final String DEFAULT_LOG_CONFIG_FILE = "classpath:sentinel.properties";
    private static final Properties properties = new Properties();

    private static void load() {
        Properties p;
        String fileName = System.getProperty(LOG_CONFIG_PROPERTY_KEY);
        if (StringUtil.isBlank(fileName) && StringUtil.isBlank(fileName = System.getenv(LOG_CONFIG_ENV_KEY))) {
            fileName = DEFAULT_LOG_CONFIG_FILE;
        }
        if ((p = ConfigUtil.loadProperties(fileName)) != null && !p.isEmpty()) {
            properties.putAll((Map<?, ?>)p);
        }
        CopyOnWriteArraySet<Map.Entry<Object, Object>> copy = new CopyOnWriteArraySet<Map.Entry<Object, Object>>(System.getProperties().entrySet());
        for (Map.Entry<Object, Object> entry : copy) {
            String configKey = entry.getKey().toString();
            String newConfigValue = entry.getValue().toString();
            properties.put(configKey, newConfigValue);
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    static {
        try {
            LogConfigLoader.load();
        }
        catch (Throwable t) {
            System.err.println("[LogConfigLoader] Failed to initialize configuration items");
            t.printStackTrace();
        }
    }
}

