/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.log.jul;

import com.yeepay.shade.com.alibaba.csp.sentinel.log.LogBase;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.jul.ConsoleHandler;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.jul.CspFormatter;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.jul.DateFileLogHandler;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.jul.FormattingTuple;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.jul.MessageFormatter;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.PidUtil;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseJulLogger {
    protected void log(Logger logger, Handler handler, Level level, String detail, Object ... params) {
        if (detail == null) {
            return;
        }
        BaseJulLogger.disableOtherHandlers(logger, handler);
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(detail, params);
        String message = formattingTuple.getMessage();
        logger.log(level, message);
    }

    protected void log(Logger logger, Handler handler, Level level, String detail, Throwable throwable) {
        if (detail == null) {
            return;
        }
        BaseJulLogger.disableOtherHandlers(logger, handler);
        logger.log(level, detail, throwable);
    }

    protected Handler makeLoggingHandler(String logName, Logger heliumRecordLog) {
        CspFormatter formatter = new CspFormatter();
        String logCharSet = LogBase.getLogCharset();
        Handler handler = null;
        switch (LogBase.getLogOutputType()) {
            case "file": {
                String fileName = LogBase.getLogBaseDir() + logName;
                if (LogBase.isLogNameUsePid()) {
                    fileName = fileName + ".pid" + PidUtil.getPid();
                }
                try {
                    handler = new DateFileLogHandler(fileName + ".%d", 0xC800000, 4, true);
                    handler.setFormatter(formatter);
                    handler.setEncoding(logCharSet);
                    handler.setLevel(LogBase.getLogLevel());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "console": {
                try {
                    handler = new ConsoleHandler();
                    handler.setFormatter(formatter);
                    handler.setEncoding(logCharSet);
                    handler.setLevel(LogBase.getLogLevel());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (handler != null) {
            BaseJulLogger.disableOtherHandlers(heliumRecordLog, handler);
        }
        heliumRecordLog.setLevel(LogBase.getLogLevel());
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableOtherHandlers(Logger logger, Handler handler) {
        if (logger == null) {
            return;
        }
        Logger logger2 = logger;
        synchronized (logger2) {
            Handler[] handlers = logger.getHandlers();
            if (handlers == null) {
                return;
            }
            if (handlers.length == 1 && handlers[0].equals(handler)) {
                return;
            }
            logger.setUseParentHandlers(false);
            for (Handler h2 : handlers) {
                logger.removeHandler(h2);
            }
            logger.addHandler(handler);
        }
    }
}

