/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.log.jul;

import com.yeepay.shade.com.alibaba.csp.sentinel.log.jul.CspFormatter;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.jul.Level;
import java.io.UnsupportedEncodingException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

class ConsoleHandler
extends Handler {
    private StreamHandler stdoutHandler = new StreamHandler(System.out, new CspFormatter());
    private StreamHandler stderrHandler = new StreamHandler(System.err, new CspFormatter());

    @Override
    public synchronized void setFormatter(Formatter newFormatter) throws SecurityException {
        this.stdoutHandler.setFormatter(newFormatter);
        this.stderrHandler.setFormatter(newFormatter);
    }

    @Override
    public synchronized void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.stdoutHandler.setEncoding(encoding);
        this.stderrHandler.setEncoding(encoding);
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            this.stderrHandler.publish(record);
            this.stderrHandler.flush();
        } else {
            this.stdoutHandler.publish(record);
            this.stdoutHandler.flush();
        }
    }

    @Override
    public void flush() {
        this.stdoutHandler.flush();
        this.stderrHandler.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.stdoutHandler.close();
        this.stderrHandler.close();
    }
}

