/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.metric.extension.callback;

import com.yeepay.shade.com.alibaba.csp.sentinel.Entry;
import com.yeepay.shade.com.alibaba.csp.sentinel.context.Context;
import com.yeepay.shade.com.alibaba.csp.sentinel.metric.extension.AdvancedMetricExtension;
import com.yeepay.shade.com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import com.yeepay.shade.com.alibaba.csp.sentinel.metric.extension.MetricExtensionProvider;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.ProcessorSlotExitCallback;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.TimeUtil;

public class MetricExitCallback
implements ProcessorSlotExitCallback {
    @Override
    public void onExit(Context context, ResourceWrapper rw, int acquireCount, Object ... args) {
        Entry curEntry = context.getCurEntry();
        if (curEntry == null) {
            return;
        }
        for (MetricExtension m3 : MetricExtensionProvider.getMetricExtensions()) {
            if (curEntry.getBlockError() != null) continue;
            String resource = rw.getName();
            Throwable ex = curEntry.getError();
            long completeTime = curEntry.getCompleteTimestamp();
            if (completeTime <= 0L) {
                completeTime = TimeUtil.currentTimeMillis();
            }
            long rt = completeTime - curEntry.getCreateTimestamp();
            if (m3 instanceof AdvancedMetricExtension) {
                ((AdvancedMetricExtension)m3).onComplete(rw, rt, acquireCount, args);
                if (ex == null) continue;
                ((AdvancedMetricExtension)m3).onError(rw, ex, acquireCount, args);
                continue;
            }
            m3.addRt(resource, rt, args);
            m3.addSuccess(resource, acquireCount, args);
            m3.decreaseThreadNum(resource, args);
            if (null == ex) continue;
            m3.addException(resource, acquireCount, ex);
        }
    }
}

