/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.node;

import com.yeepay.shade.com.alibaba.csp.sentinel.node.Node;
import com.yeepay.shade.com.alibaba.csp.sentinel.node.StatisticNode;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ClusterNode
extends StatisticNode {
    private final String name;
    private final int resourceType;
    private Map<String, StatisticNode> originCountMap = new HashMap<String, StatisticNode>();
    private final ReentrantLock lock = new ReentrantLock();

    public ClusterNode(String name) {
        this(name, 0);
    }

    public ClusterNode(String name, int resourceType) {
        AssertUtil.notEmpty(name, "name cannot be empty");
        this.name = name;
        this.resourceType = resourceType;
    }

    public String getName() {
        return this.name;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getOrCreateOriginNode(String origin) {
        StatisticNode statisticNode = this.originCountMap.get(origin);
        if (statisticNode == null) {
            this.lock.lock();
            try {
                statisticNode = this.originCountMap.get(origin);
                if (statisticNode == null) {
                    statisticNode = new StatisticNode();
                    HashMap<String, StatisticNode> newMap = new HashMap<String, StatisticNode>(this.originCountMap.size() + 1);
                    newMap.putAll(this.originCountMap);
                    newMap.put(origin, statisticNode);
                    this.originCountMap = newMap;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return statisticNode;
    }

    public Map<String, StatisticNode> getOriginCountMap() {
        return this.originCountMap;
    }
}

