/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.node;

import com.yeepay.shade.com.alibaba.csp.sentinel.log.RecordLog;
import com.yeepay.shade.com.alibaba.csp.sentinel.node.IntervalProperty;
import com.yeepay.shade.com.alibaba.csp.sentinel.property.PropertyListener;
import com.yeepay.shade.com.alibaba.csp.sentinel.property.SentinelProperty;
import com.yeepay.shade.com.alibaba.csp.sentinel.property.SimplePropertyListener;

public class OccupyTimeoutProperty {
    private static volatile int occupyTimeout = 500;

    public static void register2Property(SentinelProperty<Integer> property) {
        property.addListener((PropertyListener<Integer>)new SimplePropertyListener<Integer>(){

            @Override
            public void configUpdate(Integer value) {
                if (value != null) {
                    OccupyTimeoutProperty.updateTimeout(value);
                }
            }
        });
    }

    public static int getOccupyTimeout() {
        return occupyTimeout;
    }

    public static void updateTimeout(int newInterval) {
        if (newInterval < 0) {
            RecordLog.warn("[OccupyTimeoutProperty] Illegal timeout value will be ignored: " + occupyTimeout, new Object[0]);
            return;
        }
        if (newInterval > IntervalProperty.INTERVAL) {
            RecordLog.warn("[OccupyTimeoutProperty] Illegal timeout value will be ignored: {}, should <= {}", occupyTimeout, IntervalProperty.INTERVAL);
            return;
        }
        if (newInterval != occupyTimeout) {
            occupyTimeout = newInterval;
        }
        RecordLog.info("[OccupyTimeoutProperty] occupyTimeout updated to: {}", occupyTimeout);
    }
}

