/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.property;

import com.yeepay.shade.com.alibaba.csp.sentinel.log.RecordLog;
import com.yeepay.shade.com.alibaba.csp.sentinel.property.PropertyListener;
import com.yeepay.shade.com.alibaba.csp.sentinel.property.SentinelProperty;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class DynamicSentinelProperty<T>
implements SentinelProperty<T> {
    protected Set<PropertyListener<T>> listeners = new CopyOnWriteArraySet<PropertyListener<T>>();
    private T value = null;

    public DynamicSentinelProperty() {
    }

    public DynamicSentinelProperty(T value) {
        this.value = value;
    }

    @Override
    public void addListener(PropertyListener<T> listener) {
        this.listeners.add(listener);
        listener.configLoad(this.value);
    }

    @Override
    public void removeListener(PropertyListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean updateValue(T newValue) {
        if (this.isEqual(this.value, newValue)) {
            return false;
        }
        RecordLog.info("[DynamicSentinelProperty] Config will be updated to: {}", newValue);
        this.value = newValue;
        for (PropertyListener<T> listener : this.listeners) {
            listener.configUpdate(newValue);
        }
        return true;
    }

    private boolean isEqual(T oldValue, T newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null) {
            return false;
        }
        return oldValue.equals(newValue);
    }

    public void close() {
        this.listeners.clear();
    }
}

