/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker;

import com.yeepay.shade.com.alibaba.csp.sentinel.Entry;
import com.yeepay.shade.com.alibaba.csp.sentinel.context.Context;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreakerStateChangeObserver;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.EventObserverRegistry;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.AssertUtil;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.TimeUtil;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.function.BiConsumer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractCircuitBreaker
implements CircuitBreaker {
    protected final DegradeRule rule;
    protected final int recoveryTimeoutMs;
    private final EventObserverRegistry observerRegistry;
    protected final AtomicReference<CircuitBreaker.State> currentState = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    protected volatile long nextRetryTimestamp;

    public AbstractCircuitBreaker(DegradeRule rule) {
        this(rule, EventObserverRegistry.getInstance());
    }

    AbstractCircuitBreaker(DegradeRule rule, EventObserverRegistry observerRegistry) {
        AssertUtil.notNull(observerRegistry, "observerRegistry cannot be null");
        if (!DegradeRuleManager.isValidRule(rule)) {
            throw new IllegalArgumentException("Invalid DegradeRule: " + rule);
        }
        this.observerRegistry = observerRegistry;
        this.rule = rule;
        this.recoveryTimeoutMs = rule.getTimeWindow() * 1000;
    }

    @Override
    public DegradeRule getRule() {
        return this.rule;
    }

    @Override
    public CircuitBreaker.State currentState() {
        return this.currentState.get();
    }

    @Override
    public boolean tryPass(Context context) {
        if (this.currentState.get() == CircuitBreaker.State.CLOSED) {
            return true;
        }
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return this.retryTimeoutArrived() && this.fromOpenToHalfOpen(context);
        }
        return false;
    }

    abstract void resetStat();

    protected boolean retryTimeoutArrived() {
        return TimeUtil.currentTimeMillis() >= this.nextRetryTimestamp;
    }

    protected void updateNextRetryTimestamp() {
        this.nextRetryTimestamp = TimeUtil.currentTimeMillis() + (long)this.recoveryTimeoutMs;
    }

    protected boolean fromCloseToOpen(double snapshotValue) {
        CircuitBreaker.State prev = CircuitBreaker.State.CLOSED;
        if (this.currentState.compareAndSet(prev, CircuitBreaker.State.OPEN)) {
            this.updateNextRetryTimestamp();
            this.notifyObservers(prev, CircuitBreaker.State.OPEN, snapshotValue);
            return true;
        }
        return false;
    }

    protected boolean fromOpenToHalfOpen(Context context) {
        if (this.currentState.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN)) {
            this.notifyObservers(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN, null);
            Entry entry = context.getCurEntry();
            entry.whenTerminate(new BiConsumer<Context, Entry>(){

                @Override
                public void accept(Context context, Entry entry) {
                    if (entry.getBlockError() != null) {
                        AbstractCircuitBreaker.this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN);
                        AbstractCircuitBreaker.this.notifyObservers(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN, 1.0);
                    }
                }
            });
            return true;
        }
        return false;
    }

    private void notifyObservers(CircuitBreaker.State prevState, CircuitBreaker.State newState, Double snapshotValue) {
        for (CircuitBreakerStateChangeObserver observer : this.observerRegistry.getStateChangeObservers()) {
            observer.onStateChange(prevState, newState, this.rule, snapshotValue);
        }
    }

    protected boolean fromHalfOpenToOpen(double snapshotValue) {
        if (this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN)) {
            this.updateNextRetryTimestamp();
            this.notifyObservers(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN, snapshotValue);
            return true;
        }
        return false;
    }

    protected boolean fromHalfOpenToClose() {
        if (this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED)) {
            this.resetStat();
            this.notifyObservers(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED, null);
            return true;
        }
        return false;
    }

    protected void transformToOpen(double triggerValue) {
        CircuitBreaker.State cs = this.currentState.get();
        switch (cs) {
            case CLOSED: {
                this.fromCloseToOpen(triggerValue);
                break;
            }
            case HALF_OPEN: {
                this.fromHalfOpenToOpen(triggerValue);
                break;
            }
        }
    }
}

