/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker;

import com.yeepay.shade.com.alibaba.csp.sentinel.Entry;
import com.yeepay.shade.com.alibaba.csp.sentinel.context.Context;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.AbstractCircuitBreaker;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

public class ExceptionCircuitBreaker
extends AbstractCircuitBreaker {
    private final int strategy;
    private final int minRequestAmount;
    private final double threshold;
    private final LeapArray<SimpleErrorCounter> stat;

    public ExceptionCircuitBreaker(DegradeRule rule) {
        this(rule, new SimpleErrorCounterLeapArray(1, rule.getStatIntervalMs()));
    }

    ExceptionCircuitBreaker(DegradeRule rule, LeapArray<SimpleErrorCounter> stat) {
        super(rule);
        this.strategy = rule.getGrade();
        boolean modeOk = this.strategy == 1 || this.strategy == 2;
        AssertUtil.isTrue(modeOk, "rule strategy should be error-ratio or error-count");
        AssertUtil.notNull(stat, "stat cannot be null");
        this.minRequestAmount = rule.getMinRequestAmount();
        this.threshold = rule.getCount();
        this.stat = stat;
    }

    @Override
    protected void resetStat() {
        this.stat.currentWindow().value().reset();
    }

    @Override
    public void onRequestComplete(Context context) {
        Entry entry = context.getCurEntry();
        if (entry == null) {
            return;
        }
        Throwable error = entry.getError();
        SimpleErrorCounter counter = this.stat.currentWindow().value();
        if (error != null) {
            counter.getErrorCount().add(1L);
        }
        counter.getTotalCount().add(1L);
        this.handleStateChangeWhenThresholdExceeded(error);
    }

    private void handleStateChangeWhenThresholdExceeded(Throwable error) {
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return;
        }
        if (this.currentState.get() == CircuitBreaker.State.HALF_OPEN) {
            if (error == null) {
                this.fromHalfOpenToClose();
            } else {
                this.fromHalfOpenToOpen(1.0);
            }
            return;
        }
        List<SimpleErrorCounter> counters = this.stat.values();
        long errCount = 0L;
        long totalCount = 0L;
        for (SimpleErrorCounter counter : counters) {
            errCount += counter.errorCount.sum();
            totalCount += counter.totalCount.sum();
        }
        if (totalCount < (long)this.minRequestAmount) {
            return;
        }
        double curCount = errCount;
        if (this.strategy == 1) {
            curCount = (double)errCount * 1.0 / (double)totalCount;
        }
        if (curCount > this.threshold) {
            this.transformToOpen(curCount);
        }
    }

    static class SimpleErrorCounterLeapArray
    extends LeapArray<SimpleErrorCounter> {
        public SimpleErrorCounterLeapArray(int sampleCount, int intervalInMs) {
            super(sampleCount, intervalInMs);
        }

        @Override
        public SimpleErrorCounter newEmptyBucket(long timeMillis) {
            return new SimpleErrorCounter();
        }

        @Override
        protected WindowWrap<SimpleErrorCounter> resetWindowTo(WindowWrap<SimpleErrorCounter> w, long startTime) {
            w.resetTo(startTime);
            w.value().reset();
            return w;
        }
    }

    static class SimpleErrorCounter {
        private LongAdder errorCount = new LongAdder();
        private LongAdder totalCount = new LongAdder();

        public LongAdder getErrorCount() {
            return this.errorCount;
        }

        public LongAdder getTotalCount() {
            return this.totalCount;
        }

        public SimpleErrorCounter reset() {
            this.errorCount.reset();
            this.totalCount.reset();
            return this;
        }

        public String toString() {
            return "SimpleErrorCounter{errorCount=" + this.errorCount + ", totalCount=" + this.totalCount + '}';
        }
    }
}

