/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.flow;

import com.yeepay.shade.com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.yeepay.shade.com.alibaba.csp.sentinel.cluster.TokenResult;
import com.yeepay.shade.com.alibaba.csp.sentinel.cluster.TokenService;
import com.yeepay.shade.com.alibaba.csp.sentinel.cluster.client.TokenClientProvider;
import com.yeepay.shade.com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServerProvider;
import com.yeepay.shade.com.alibaba.csp.sentinel.context.Context;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.RecordLog;
import com.yeepay.shade.com.alibaba.csp.sentinel.node.DefaultNode;
import com.yeepay.shade.com.alibaba.csp.sentinel.node.Node;
import com.yeepay.shade.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.BlockException;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.StringUtil;
import com.yeepay.shade.com.alibaba.csp.sentinel.util.function.Function;
import java.util.Collection;

public class FlowRuleChecker {
    public void checkFlow(Function<String, Collection<FlowRule>> ruleProvider, ResourceWrapper resource, Context context, DefaultNode node, int count, boolean prioritized) throws BlockException {
        if (ruleProvider == null || resource == null) {
            return;
        }
        Collection<FlowRule> rules = ruleProvider.apply(resource.getName());
        if (rules != null) {
            for (FlowRule rule : rules) {
                if (this.canPassCheck(rule, context, node, count, prioritized)) continue;
                throw new FlowException(rule.getLimitApp(), rule);
            }
        }
    }

    public boolean canPassCheck(FlowRule rule, Context context, DefaultNode node, int acquireCount) {
        return this.canPassCheck(rule, context, node, acquireCount, false);
    }

    public boolean canPassCheck(FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        String limitApp = rule.getLimitApp();
        if (limitApp == null) {
            return true;
        }
        if (rule.isClusterMode()) {
            return FlowRuleChecker.passClusterCheck(rule, context, node, acquireCount, prioritized);
        }
        return FlowRuleChecker.passLocalCheck(rule, context, node, acquireCount, prioritized);
    }

    private static boolean passLocalCheck(FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        Node selectedNode = FlowRuleChecker.selectNodeByRequesterAndStrategy(rule, context, node);
        if (selectedNode == null) {
            return true;
        }
        return rule.getRater().canPass(selectedNode, acquireCount, prioritized);
    }

    static Node selectReferenceNode(FlowRule rule, Context context, DefaultNode node) {
        String refResource = rule.getRefResource();
        int strategy = rule.getStrategy();
        if (StringUtil.isEmpty(refResource)) {
            return null;
        }
        if (strategy == 1) {
            return ClusterBuilderSlot.getClusterNode(refResource);
        }
        if (strategy == 2) {
            if (!refResource.equals(context.getName())) {
                return null;
            }
            return node;
        }
        return null;
    }

    private static boolean filterOrigin(String origin) {
        return !"default".equals(origin) && !"other".equals(origin);
    }

    static Node selectNodeByRequesterAndStrategy(FlowRule rule, Context context, DefaultNode node) {
        String limitApp = rule.getLimitApp();
        int strategy = rule.getStrategy();
        String origin = context.getOrigin();
        if (limitApp.equals(origin) && FlowRuleChecker.filterOrigin(origin)) {
            if (strategy == 0) {
                return context.getOriginNode();
            }
            return FlowRuleChecker.selectReferenceNode(rule, context, node);
        }
        if ("default".equals(limitApp)) {
            if (strategy == 0) {
                return node.getClusterNode();
            }
            return FlowRuleChecker.selectReferenceNode(rule, context, node);
        }
        if ("other".equals(limitApp) && FlowRuleManager.isOtherOrigin(origin, rule.getResource())) {
            if (strategy == 0) {
                return context.getOriginNode();
            }
            return FlowRuleChecker.selectReferenceNode(rule, context, node);
        }
        return null;
    }

    private static boolean passClusterCheck(FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        try {
            TokenService clusterService = FlowRuleChecker.pickClusterService();
            if (clusterService == null) {
                return FlowRuleChecker.fallbackToLocalOrPass(rule, context, node, acquireCount, prioritized);
            }
            long flowId = rule.getClusterConfig().getFlowId();
            TokenResult result = clusterService.requestToken(flowId, acquireCount, prioritized);
            return FlowRuleChecker.applyTokenResult(result, rule, context, node, acquireCount, prioritized);
        }
        catch (Throwable ex) {
            RecordLog.warn("[FlowRuleChecker] Request cluster token unexpected failed", ex);
            return FlowRuleChecker.fallbackToLocalOrPass(rule, context, node, acquireCount, prioritized);
        }
    }

    private static boolean fallbackToLocalOrPass(FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        if (rule.getClusterConfig().isFallbackToLocalWhenFail()) {
            return FlowRuleChecker.passLocalCheck(rule, context, node, acquireCount, prioritized);
        }
        return true;
    }

    private static TokenService pickClusterService() {
        if (ClusterStateManager.isClient()) {
            return TokenClientProvider.getClient();
        }
        if (ClusterStateManager.isServer()) {
            return EmbeddedClusterTokenServerProvider.getServer();
        }
        return null;
    }

    private static boolean applyTokenResult(TokenResult result, FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        switch (result.getStatus()) {
            case 0: {
                return true;
            }
            case 2: {
                try {
                    Thread.sleep(result.getWaitInMs());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
            case -4: 
            case -2: 
            case -1: 
            case 3: {
                return FlowRuleChecker.fallbackToLocalOrPass(rule, context, node, acquireCount, prioritized);
            }
        }
        return false;
    }
}

