/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.slots.system;

import com.sun.management.OperatingSystemMXBean;
import com.yeepay.shade.com.alibaba.csp.sentinel.Constants;
import com.yeepay.shade.com.alibaba.csp.sentinel.log.RecordLog;
import com.yeepay.shade.com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.TimeUnit;

public class SystemStatusListener
implements Runnable {
    volatile double currentLoad = -1.0;
    volatile double currentCpuUsage = -1.0;
    volatile String reason = "";
    volatile long processCpuTime = 0L;
    volatile long processUpTime = 0L;

    public double getSystemAverageLoad() {
        return this.currentLoad;
    }

    public double getCpuUsage() {
        return this.currentCpuUsage;
    }

    @Override
    public void run() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            this.currentLoad = osBean.getSystemLoadAverage();
            double systemCpuUsage = osBean.getSystemCpuLoad();
            RuntimeMXBean runtimeBean = ManagementFactory.getPlatformMXBean(RuntimeMXBean.class);
            long newProcessCpuTime = osBean.getProcessCpuTime();
            long newProcessUpTime = runtimeBean.getUptime();
            int cpuCores = osBean.getAvailableProcessors();
            long processCpuTimeDiffInMs = TimeUnit.NANOSECONDS.toMillis(newProcessCpuTime - this.processCpuTime);
            long processUpTimeDiffInMs = newProcessUpTime - this.processUpTime;
            double processCpuUsage = (double)processCpuTimeDiffInMs / (double)processUpTimeDiffInMs / (double)cpuCores;
            this.processCpuTime = newProcessCpuTime;
            this.processUpTime = newProcessUpTime;
            this.currentCpuUsage = Math.max(processCpuUsage, systemCpuUsage);
            if (this.currentLoad > SystemRuleManager.getSystemLoadThreshold()) {
                this.writeSystemStatusLog();
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[SystemStatusListener] Failed to get system metrics from JMX", e);
        }
    }

    private void writeSystemStatusLog() {
        StringBuilder sb = new StringBuilder();
        sb.append("Load exceeds the threshold: ");
        sb.append("load:").append(String.format("%.4f", this.currentLoad)).append("; ");
        sb.append("cpuUsage:").append(String.format("%.4f", this.currentCpuUsage)).append("; ");
        sb.append("qps:").append(String.format("%.4f", Constants.ENTRY_NODE.passQps())).append("; ");
        sb.append("rt:").append(String.format("%.4f", Constants.ENTRY_NODE.avgRt())).append("; ");
        sb.append("thread:").append(Constants.ENTRY_NODE.curThreadNum()).append("; ");
        sb.append("success:").append(String.format("%.4f", Constants.ENTRY_NODE.successQps())).append("; ");
        sb.append("minRt:").append(String.format("%.2f", Constants.ENTRY_NODE.minRt())).append("; ");
        sb.append("maxSuccess:").append(String.format("%.2f", Constants.ENTRY_NODE.maxSuccessQps())).append("; ");
        RecordLog.info(sb.toString(), new Object[0]);
    }
}

