/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.alibaba.csp.sentinel.util;

import com.yeepay.shade.com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public final class ConfigUtil {
    public static final String CLASSPATH_FILE_FLAG = "classpath:";

    public static Properties loadProperties(String fileName) {
        if (StringUtil.isNotBlank(fileName)) {
            if (ConfigUtil.absolutePathStart(fileName)) {
                return ConfigUtil.loadPropertiesFromAbsoluteFile(fileName);
            }
            if (fileName.startsWith(CLASSPATH_FILE_FLAG)) {
                return ConfigUtil.loadPropertiesFromClasspathFile(fileName);
            }
            return ConfigUtil.loadPropertiesFromRelativeFile(fileName);
        }
        return null;
    }

    private static Properties loadPropertiesFromAbsoluteFile(String fileName) {
        Properties properties = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ConfigUtil.getCharset()));){
                properties = new Properties();
                properties.load(bufferedReader);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static boolean absolutePathStart(String path) {
        File[] files;
        for (File file : files = File.listRoots()) {
            if (!path.startsWith(file.getPath())) continue;
            return true;
        }
        return false;
    }

    private static Properties loadPropertiesFromClasspathFile(String fileName) {
        fileName = fileName.substring(CLASSPATH_FILE_FLAG.length()).trim();
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = ConfigUtil.getClassLoader().getResources(fileName);
            list = new ArrayList();
            while (urls.hasMoreElements()) {
                list.add(urls.nextElement());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (list.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        for (URL url : list) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), ConfigUtil.getCharset()));
                Throwable throwable = null;
                try {
                    Properties p = new Properties();
                    p.load(bufferedReader);
                    properties.putAll((Map<?, ?>)p);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bufferedReader == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bufferedReader.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private static Properties loadPropertiesFromRelativeFile(String fileName) {
        String userDir = System.getProperty("user.dir");
        String realFilePath = ConfigUtil.addSeparator(userDir) + fileName;
        return ConfigUtil.loadPropertiesFromAbsoluteFile(realFilePath);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ConfigUtil.class.getClassLoader();
        }
        return classLoader;
    }

    private static Charset getCharset() {
        return Charset.forName(System.getProperty("csp.sentinel.charset", StandardCharsets.UTF_8.name()));
    }

    public static String addSeparator(String dir) {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir;
    }

    private ConfigUtil() {
    }
}

