/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.fasterxml.jackson.datatype.joda.ser;

import com.yeepay.shade.com.fasterxml.jackson.core.JsonGenerator;
import com.yeepay.shade.com.fasterxml.jackson.databind.SerializationFeature;
import com.yeepay.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.yeepay.shade.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.yeepay.shade.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.yeepay.shade.com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import com.yeepay.shade.org.joda.time.LocalTime;
import java.io.IOException;

public class LocalTimeSerializer
extends JodaDateSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;

    public LocalTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_TIMEONLY_PRINTER, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(LocalTime.class, format, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalTimeSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new LocalTimeSerializer(formatter, shapeOverride);
    }

    @Override
    public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._serializationShape(provider) == 1) {
            gen.writeString(this._format.createFormatter(provider).print(value));
            return;
        }
        gen.writeStartArray();
        gen.writeNumber(value.hourOfDay().get());
        gen.writeNumber(value.minuteOfHour().get());
        gen.writeNumber(value.secondOfMinute().get());
        gen.writeNumber(value.millisOfSecond().get());
        gen.writeEndArray();
    }
}

