/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.apache.tika.detect;

import com.yeepay.shade.org.apache.tika.io.CloseShieldInputStream;
import com.yeepay.shade.org.apache.tika.parser.ParseContext;
import com.yeepay.shade.org.apache.tika.sax.OfflineContentHandler;
import com.yeepay.shade.org.apache.tika.utils.XMLReaderUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRootExtractor {
    private static final ParseContext EMPTY_CONTEXT = new ParseContext();

    public QName extractRootElement(byte[] data) {
        return this.extractRootElement(new ByteArrayInputStream(data));
    }

    public QName extractRootElement(InputStream stream) {
        ExtractorHandler handler = new ExtractorHandler();
        try {
            XMLReaderUtils.parseSAX(new CloseShieldInputStream(stream), new OfflineContentHandler(handler), EMPTY_CONTEXT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.rootElement;
    }

    private static class ExtractorHandler
    extends DefaultHandler {
        private QName rootElement = null;

        private ExtractorHandler() {
        }

        @Override
        public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
            this.rootElement = new QName(uri, local);
            throw new SAXException("Aborting: root element received");
        }
    }
}

