/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.apache.tika.parser.digest;

import com.yeepay.shade.org.apache.tika.exception.TikaException;
import com.yeepay.shade.org.apache.tika.io.IOExceptionWithCause;
import com.yeepay.shade.org.apache.tika.io.TemporaryResources;
import com.yeepay.shade.org.apache.tika.io.TikaInputStream;
import com.yeepay.shade.org.apache.tika.metadata.Metadata;
import com.yeepay.shade.org.apache.tika.parser.DigestingParser;
import com.yeepay.shade.org.apache.tika.parser.ParseContext;
import java.io.IOException;
import java.io.InputStream;

public class CompositeDigester
implements DigestingParser.Digester {
    private final DigestingParser.Digester[] digesters;

    public CompositeDigester(DigestingParser.Digester ... digesters) {
        this.digesters = digesters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void digest(InputStream is, Metadata m3, ParseContext parseContext) throws IOException {
        TemporaryResources tmp = new TemporaryResources();
        TikaInputStream tis = TikaInputStream.get(is, tmp);
        try {
            for (DigestingParser.Digester digester : this.digesters) {
                digester.digest(tis, m3, parseContext);
            }
        }
        finally {
            try {
                tmp.dispose();
            }
            catch (TikaException e) {
                throw new IOExceptionWithCause(e);
            }
        }
    }
}

