/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.apache.tika.sax;

import com.yeepay.shade.org.apache.tika.metadata.Metadata;
import com.yeepay.shade.org.apache.tika.metadata.Property;
import com.yeepay.shade.org.apache.tika.sax.ContentHandlerFactory;
import com.yeepay.shade.org.apache.tika.utils.ParserUtils;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractRecursiveParserWrapperHandler
extends DefaultHandler
implements Serializable {
    public static final Property TIKA_CONTENT = Property.internalText("X-TIKA:content");
    public static final Property TIKA_CONTENT_HANDLER = Property.internalText("X-TIKA:content_handler");
    public static final Property PARSE_TIME_MILLIS = Property.internalText("X-TIKA:parse_time_millis");
    public static final Property WRITE_LIMIT_REACHED = Property.internalBoolean("X-TIKA:EXCEPTION:write_limit_reached");
    public static final Property EMBEDDED_RESOURCE_LIMIT_REACHED = Property.internalBoolean("X-TIKA:EXCEPTION:embedded_resource_limit_reached");
    public static final Property EMBEDDED_EXCEPTION = ParserUtils.EMBEDDED_EXCEPTION;
    public static final Property EMBEDDED_RESOURCE_PATH = Property.internalText("X-TIKA:embedded_resource_path");
    private final ContentHandlerFactory contentHandlerFactory;
    private static final int MAX_DEPTH = 100;
    private final int maxEmbeddedResources;
    private int embeddedResources = 0;
    private int embeddedDepth = 0;

    public AbstractRecursiveParserWrapperHandler(ContentHandlerFactory contentHandlerFactory) {
        this(contentHandlerFactory, -1);
    }

    public AbstractRecursiveParserWrapperHandler(ContentHandlerFactory contentHandlerFactory, int maxEmbeddedResources) {
        this.contentHandlerFactory = contentHandlerFactory;
        this.maxEmbeddedResources = maxEmbeddedResources;
    }

    public ContentHandler getNewContentHandler() {
        return this.contentHandlerFactory.getNewContentHandler();
    }

    public ContentHandler getNewContentHandler(OutputStream os, Charset charset) {
        return this.contentHandlerFactory.getNewContentHandler(os, charset);
    }

    public void startEmbeddedDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        ++this.embeddedResources;
        ++this.embeddedDepth;
        if (this.embeddedDepth >= 100) {
            throw new SAXException("Max embedded depth reached: " + this.embeddedDepth);
        }
    }

    public void endEmbeddedDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        --this.embeddedDepth;
    }

    public void endDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        if (this.hasHitMaximumEmbeddedResources()) {
            metadata.set(EMBEDDED_RESOURCE_LIMIT_REACHED, "true");
        }
    }

    public boolean hasHitMaximumEmbeddedResources() {
        return this.maxEmbeddedResources > -1 && this.embeddedResources >= this.maxEmbeddedResources;
    }

    public ContentHandlerFactory getContentHandlerFactory() {
        return this.contentHandlerFactory;
    }
}

