/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.apache.tika.sax;

import com.yeepay.shade.org.apache.tika.metadata.Metadata;
import com.yeepay.shade.org.apache.tika.sax.AbstractRecursiveParserWrapperHandler;
import com.yeepay.shade.org.apache.tika.sax.ContentHandlerFactory;
import com.yeepay.shade.org.apache.tika.utils.ParserUtils;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RecursiveParserWrapperHandler
extends AbstractRecursiveParserWrapperHandler {
    protected final List<Metadata> metadataList = new LinkedList<Metadata>();

    public RecursiveParserWrapperHandler(ContentHandlerFactory contentHandlerFactory) {
        super(contentHandlerFactory);
    }

    public RecursiveParserWrapperHandler(ContentHandlerFactory contentHandlerFactory, int maxEmbeddedResources) {
        super(contentHandlerFactory, maxEmbeddedResources);
    }

    @Override
    public void startEmbeddedDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        super.startEmbeddedDocument(contentHandler, metadata);
    }

    @Override
    public void endEmbeddedDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        super.endEmbeddedDocument(contentHandler, metadata);
        this.addContent(contentHandler, metadata);
        this.metadataList.add(ParserUtils.cloneMetadata(metadata));
    }

    @Override
    public void endDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
        super.endDocument(contentHandler, metadata);
        this.addContent(contentHandler, metadata);
        this.metadataList.add(0, ParserUtils.cloneMetadata(metadata));
    }

    public List<Metadata> getMetadataList() {
        return this.metadataList;
    }

    void addContent(ContentHandler handler, Metadata metadata) {
        String content;
        if (!handler.getClass().equals(DefaultHandler.class) && (content = handler.toString()) != null && content.trim().length() > 0) {
            metadata.add(TIKA_CONTENT, content);
            metadata.add(TIKA_CONTENT_HANDLER, handler.getClass().getSimpleName());
        }
    }
}

