/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core;

import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public abstract class KotlinDetector {
    @Nullable
    private static final Class<? extends Annotation> kotlinMetadata;
    private static final boolean kotlinReflectPresent;

    public static boolean isKotlinPresent() {
        return kotlinMetadata != null;
    }

    public static boolean isKotlinReflectPresent() {
        return kotlinReflectPresent;
    }

    public static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    public static boolean isSuspendingFunction(Method method) {
        Class<?>[] types;
        return KotlinDetector.isKotlinType(method.getDeclaringClass()) && (types = method.getParameterTypes()).length > 0 && "kotlin.coroutines.Continuation".equals(types[types.length - 1].getName());
    }

    static {
        Class<?> metadata;
        ClassLoader classLoader = KotlinDetector.class.getClassLoader();
        try {
            metadata = ClassUtils.forName("kotlin.Metadata", classLoader);
        }
        catch (ClassNotFoundException ex) {
            metadata = null;
        }
        kotlinMetadata = metadata;
        kotlinReflectPresent = ClassUtils.isPresent("kotlin.reflect.full.KClasses", classLoader);
    }
}

