/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.annotation;

import com.yeepay.shade.org.springframework.core.annotation.MergedAnnotation;
import com.yeepay.shade.org.springframework.core.annotation.MergedAnnotations;
import com.yeepay.shade.org.springframework.core.annotation.Order;
import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.ConcurrentReferenceHashMap;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;

public abstract class OrderUtils {
    private static final Object NOT_ANNOTATED = new Object();
    private static final String JAVAX_PRIORITY_ANNOTATION = "com.yeepay.shade.javax.annotation.Priority";
    private static final Map<AnnotatedElement, Object> orderCache = new ConcurrentReferenceHashMap<AnnotatedElement, Object>(64);

    public static int getOrder(Class<?> type, int defaultOrder) {
        Integer order = OrderUtils.getOrder(type);
        return order != null ? order : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type, @Nullable Integer defaultOrder) {
        Integer order = OrderUtils.getOrder(type);
        return order != null ? order : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type) {
        return OrderUtils.getOrder(type);
    }

    @Nullable
    public static Integer getOrder(AnnotatedElement element) {
        return OrderUtils.getOrderFromAnnotations(element, MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
    }

    @Nullable
    static Integer getOrderFromAnnotations(AnnotatedElement element, MergedAnnotations annotations) {
        if (!(element instanceof Class)) {
            return OrderUtils.findOrder(annotations);
        }
        Object cached = orderCache.get(element);
        if (cached != null) {
            return cached instanceof Integer ? (Integer)cached : null;
        }
        Integer result = OrderUtils.findOrder(annotations);
        orderCache.put(element, result != null ? result : NOT_ANNOTATED);
        return result;
    }

    @Nullable
    private static Integer findOrder(MergedAnnotations annotations) {
        MergedAnnotation<Order> orderAnnotation = annotations.get(Order.class);
        if (orderAnnotation.isPresent()) {
            return orderAnnotation.getInt("value");
        }
        MergedAnnotation priorityAnnotation = annotations.get(JAVAX_PRIORITY_ANNOTATION);
        if (priorityAnnotation.isPresent()) {
            return priorityAnnotation.getInt("value");
        }
        return null;
    }

    @Nullable
    public static Integer getPriority(Class<?> type) {
        return MergedAnnotations.from(type, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(JAVAX_PRIORITY_ANNOTATION).getValue("value", Integer.class).orElse(null);
    }
}

