/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.codec;

import com.yeepay.shade.org.springframework.core.ResolvableType;
import com.yeepay.shade.org.springframework.core.codec.AbstractEncoder;
import com.yeepay.shade.org.springframework.core.codec.Hints;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBuffer;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBufferFactory;
import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.MimeType;
import com.yeepay.shade.org.springframework.util.MimeTypeUtils;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ByteArrayEncoder
extends AbstractEncoder<byte[]> {
    public ByteArrayEncoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class<?> clazz = elementType.toClass();
        return super.canEncode(elementType, mimeType) && byte[].class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends byte[]> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(inputStream).map(bytes -> this.encodeValue((byte[])bytes, bufferFactory, elementType, mimeType, hints));
    }

    @Override
    public DataBuffer encodeValue(byte[] bytes, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        DataBuffer dataBuffer = bufferFactory.wrap(bytes);
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            String logPrefix = Hints.getLogPrefix(hints);
            this.logger.debug(logPrefix + "Writing " + dataBuffer.readableByteCount() + " bytes");
        }
        return dataBuffer;
    }
}

