/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.codec;

import com.yeepay.shade.org.springframework.core.ResolvableType;
import com.yeepay.shade.org.springframework.core.codec.AbstractDataBufferDecoder;
import com.yeepay.shade.org.springframework.core.codec.Hints;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBuffer;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBufferUtils;
import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.MimeType;
import com.yeepay.shade.org.springframework.util.MimeTypeUtils;
import java.nio.ByteBuffer;
import java.util.Map;

public class ByteBufferDecoder
extends AbstractDataBufferDecoder<ByteBuffer> {
    public ByteBufferDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return ByteBuffer.class.isAssignableFrom(elementType.toClass()) && super.canDecode(elementType, mimeType);
    }

    @Override
    public ByteBuffer decode(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        int byteCount = dataBuffer.readableByteCount();
        ByteBuffer copy = ByteBuffer.allocate(byteCount);
        copy.put(dataBuffer.asByteBuffer());
        copy.flip();
        DataBufferUtils.release(dataBuffer);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Read " + byteCount + " bytes");
        }
        return copy;
    }
}

