/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.codec;

import com.yeepay.shade.org.springframework.core.ResolvableType;
import com.yeepay.shade.org.springframework.core.codec.AbstractDataBufferDecoder;
import com.yeepay.shade.org.springframework.core.codec.Hints;
import com.yeepay.shade.org.springframework.core.io.ByteArrayResource;
import com.yeepay.shade.org.springframework.core.io.InputStreamResource;
import com.yeepay.shade.org.springframework.core.io.Resource;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBuffer;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBufferUtils;
import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.MimeType;
import com.yeepay.shade.org.springframework.util.MimeTypeUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ResourceDecoder
extends AbstractDataBufferDecoder<Resource> {
    public static String FILENAME_HINT = ResourceDecoder.class.getName() + ".filename";

    public ResourceDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return Resource.class.isAssignableFrom(elementType.toClass()) && super.canDecode(elementType, mimeType);
    }

    @Override
    public Flux<Resource> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(this.decodeToMono(inputStream, elementType, mimeType, hints));
    }

    @Override
    public Resource decode(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        String filename;
        final byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release(dataBuffer);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Read " + bytes.length + " bytes");
        }
        Class<?> clazz = elementType.toClass();
        String string = filename = hints != null ? (String)hints.get(FILENAME_HINT) : null;
        if (clazz == InputStreamResource.class) {
            return new InputStreamResource(new ByteArrayInputStream(bytes)){

                @Override
                public String getFilename() {
                    return filename;
                }

                @Override
                public long contentLength() {
                    return bytes.length;
                }
            };
        }
        if (Resource.class.isAssignableFrom(clazz)) {
            return new ByteArrayResource(bytes){

                @Override
                public String getFilename() {
                    return filename;
                }
            };
        }
        throw new IllegalStateException("Unsupported resource class: " + clazz);
    }
}

