/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.codec;

import com.yeepay.shade.org.springframework.core.ResolvableType;
import com.yeepay.shade.org.springframework.core.codec.AbstractSingleValueEncoder;
import com.yeepay.shade.org.springframework.core.codec.Hints;
import com.yeepay.shade.org.springframework.core.io.Resource;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBuffer;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBufferFactory;
import com.yeepay.shade.org.springframework.core.io.buffer.DataBufferUtils;
import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.Assert;
import com.yeepay.shade.org.springframework.util.MimeType;
import com.yeepay.shade.org.springframework.util.MimeTypeUtils;
import java.util.Map;
import reactor.core.publisher.Flux;

public class ResourceEncoder
extends AbstractSingleValueEncoder<Resource> {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final int bufferSize;

    public ResourceEncoder() {
        this(4096);
    }

    public ResourceEncoder(int bufferSize) {
        super(MimeTypeUtils.APPLICATION_OCTET_STREAM, MimeTypeUtils.ALL);
        Assert.isTrue(bufferSize > 0, "'bufferSize' must be larger than 0");
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class<?> clazz = elementType.toClass();
        return super.canEncode(elementType, mimeType) && Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Flux<DataBuffer> encode(Resource resource, DataBufferFactory bufferFactory, ResolvableType type, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            String logPrefix = Hints.getLogPrefix(hints);
            this.logger.debug(logPrefix + "Writing [" + resource + "]");
        }
        return DataBufferUtils.read(resource, bufferFactory, this.bufferSize);
    }
}

