/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.convert.support;

import com.yeepay.shade.org.springframework.core.convert.converter.Converter;
import com.yeepay.shade.org.springframework.core.convert.converter.ConverterFactory;
import com.yeepay.shade.org.springframework.core.convert.converter.ConverterRegistry;
import com.yeepay.shade.org.springframework.core.convert.converter.GenericConverter;
import com.yeepay.shade.org.springframework.lang.Nullable;
import java.util.Set;

public final class ConversionServiceFactory {
    private ConversionServiceFactory() {
    }

    public static void registerConverters(@Nullable Set<?> converters, ConverterRegistry registry) {
        if (converters != null) {
            for (Object converter : converters) {
                if (converter instanceof GenericConverter) {
                    registry.addConverter((GenericConverter)converter);
                    continue;
                }
                if (converter instanceof Converter) {
                    registry.addConverter((Converter)converter);
                    continue;
                }
                if (converter instanceof ConverterFactory) {
                    registry.addConverterFactory((ConverterFactory)converter);
                    continue;
                }
                throw new IllegalArgumentException("Each converter object must implement one of the Converter, ConverterFactory, or GenericConverter interfaces");
            }
        }
    }
}

