/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.serializer.support;

import com.yeepay.shade.org.springframework.core.convert.converter.Converter;
import com.yeepay.shade.org.springframework.core.serializer.DefaultDeserializer;
import com.yeepay.shade.org.springframework.core.serializer.Deserializer;
import com.yeepay.shade.org.springframework.core.serializer.support.SerializationFailedException;
import com.yeepay.shade.org.springframework.util.Assert;
import java.io.ByteArrayInputStream;

public class DeserializingConverter
implements Converter<byte[], Object> {
    private final Deserializer<Object> deserializer;

    public DeserializingConverter() {
        this.deserializer = new DefaultDeserializer();
    }

    public DeserializingConverter(ClassLoader classLoader) {
        this.deserializer = new DefaultDeserializer(classLoader);
    }

    public DeserializingConverter(Deserializer<Object> deserializer) {
        Assert.notNull(deserializer, "Deserializer must not be null");
        this.deserializer = deserializer;
    }

    @Override
    public Object convert(byte[] source) {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(source);
        try {
            return this.deserializer.deserialize(byteStream);
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to deserialize payload. Is the byte array a result of corresponding serialization for " + this.deserializer.getClass().getSimpleName() + "?", ex);
        }
    }
}

