/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.core.type;

import com.yeepay.shade.org.springframework.core.annotation.MergedAnnotation;
import com.yeepay.shade.org.springframework.core.annotation.MergedAnnotationCollectors;
import com.yeepay.shade.org.springframework.core.annotation.MergedAnnotationPredicates;
import com.yeepay.shade.org.springframework.core.annotation.MergedAnnotationSelectors;
import com.yeepay.shade.org.springframework.core.annotation.MergedAnnotations;
import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.MultiValueMap;
import java.util.Map;

public interface AnnotatedTypeMetadata {
    public MergedAnnotations getAnnotations();

    default public boolean isAnnotated(String annotationName) {
        return this.getAnnotations().isPresent(annotationName);
    }

    @Nullable
    default public Map<String, Object> getAnnotationAttributes(String annotationName) {
        return this.getAnnotationAttributes(annotationName, false);
    }

    @Nullable
    default public Map<String, Object> getAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        MergedAnnotation annotation = this.getAnnotations().get(annotationName, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        if (!annotation.isPresent()) {
            return null;
        }
        return annotation.asAnnotationAttributes(MergedAnnotation.Adapt.values(classValuesAsString, true));
    }

    @Nullable
    default public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName) {
        return this.getAllAnnotationAttributes(annotationName, false);
    }

    @Nullable
    default public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        MergedAnnotation.Adapt[] adaptations = MergedAnnotation.Adapt.values(classValuesAsString, true);
        return this.getAnnotations().stream(annotationName).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).map(MergedAnnotation::withNonMergedAttributes).collect(MergedAnnotationCollectors.toMultiValueMap(map -> map.isEmpty() ? null : map, adaptations));
    }
}

