/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.org.springframework.util.concurrent;

import com.yeepay.shade.org.springframework.lang.Nullable;
import com.yeepay.shade.org.springframework.util.concurrent.FailureCallback;
import com.yeepay.shade.org.springframework.util.concurrent.FutureAdapter;
import com.yeepay.shade.org.springframework.util.concurrent.ListenableFuture;
import com.yeepay.shade.org.springframework.util.concurrent.ListenableFutureCallback;
import com.yeepay.shade.org.springframework.util.concurrent.SuccessCallback;
import java.util.concurrent.ExecutionException;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.addCallback(callback, callback);
    }

    @Override
    public void addCallback(final SuccessCallback<? super T> successCallback, final FailureCallback failureCallback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(@Nullable S result) {
                Object adapted = null;
                if (result != null) {
                    try {
                        adapted = ListenableFutureAdapter.this.adaptInternal(result);
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        this.onFailure(cause != null ? cause : ex);
                        return;
                    }
                    catch (Throwable ex) {
                        this.onFailure(ex);
                        return;
                    }
                }
                successCallback.onSuccess(adapted);
            }

            @Override
            public void onFailure(Throwable ex) {
                failureCallback.onFailure(ex);
            }
        });
    }
}

