/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk;

import com.yeepay.shade.com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;

public enum Region {
    CN_N1(""),
    CN_SJ("sj"),
    CN_DJ("dj"),
    CN_M6("m6");

    private final List<String> regionIds;

    private Region(String ... regionIds) {
        Preconditions.checkNotNull(regionIds, "regionIds should not be null.");
        Preconditions.checkArgument(regionIds.length > 0, "regionIds should not be empty");
        this.regionIds = Arrays.asList(regionIds);
    }

    public String toString() {
        return this.regionIds.get(0);
    }

    public static Region fromValue(String regionId) {
        Preconditions.checkNotNull(regionId, "regionId should not be null.");
        for (Region region : Region.values()) {
            List<String> regionIds = region.regionIds;
            if (regionIds == null || !regionIds.contains(regionId)) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create region from " + regionId);
    }
}

