/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.req;

import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationReqRegistry
implements AuthorizationReqRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthorizationReqRegistry.class);
    private final Map<String, List<AuthorizationReq>> authorizationReqs = Maps.newHashMap();

    @Override
    public void register(String operationId, String securityReqs) {
        String[] splitReqs = securityReqs.split(",");
        ArrayList<AuthorizationReq> authorizationReqList = Lists.newArrayListWithExpectedSize(splitReqs.length);
        for (String securityReq : splitReqs) {
            AuthorizationReq authorizationReq = AuthorizationReqSupport.getAuthorizationReq(securityReq);
            if (null == authorizationReq) {
                LOGGER.warn("unsupported security req:{}", (Object)securityReq);
                continue;
            }
            authorizationReqList.add(authorizationReq);
        }
        this.authorizationReqs.put(operationId, authorizationReqList);
    }

    @Override
    public List<AuthorizationReq> getAuthorizationReq(String operationId) {
        return this.authorizationReqs.get(operationId);
    }
}

