/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.signer.process;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.exception.YopClientException;

public interface YopSignProcessor {
    default public String sign(String content, CredentialsItem credentialsItem) {
        if (!this.isSupport(credentialsItem)) {
            throw new YopClientException("ConfigProblem, CredentialsItem Type NotSupport, type:" + credentialsItem.getClass().getSimpleName());
        }
        return this.doSign(content, credentialsItem);
    }

    default public String doSign(String content, CredentialsItem credentialsItem) {
        return this.doSign(content, credentialsItem, null);
    }

    public String doSign(String var1, CredentialsItem var2, SignOptions var3);

    default public boolean verify(String content, String signature, CredentialsItem credentialsItem) {
        if (this.isSupport(credentialsItem)) {
            return this.doVerify(content, signature, credentialsItem);
        }
        throw new YopClientException("ConfigProblem, CredentialsItem Type NotSupport, type:" + credentialsItem.getClass().getSimpleName());
    }

    default public boolean doVerify(String content, String signature, CredentialsItem credentialsItem) {
        return this.doVerify(content, signature, credentialsItem, null);
    }

    public boolean doVerify(String var1, String var2, CredentialsItem var3, SignOptions var4);

    public boolean isSupport(CredentialsItem var1);

    public String name();

    public String getDigestAlg();
}

