/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.base.config.YopAppConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopBaseCredentialsProvider
implements YopCredentialsProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getDefaultAppKey() {
        return "default";
    }

    protected YopCredentials<?> buildCredentials(YopAppConfig appConfig, String credentialType) {
        CertTypeEnum certType;
        if (null == appConfig || StringUtils.isEmpty(credentialType) || null == (certType = CertTypeEnum.parse(credentialType))) {
            throw new YopClientException("ConfigProblem, credentialType:" + credentialType + ", appConfig:" + appConfig);
        }
        PrivateKey privateKey = appConfig.loadPrivateKey(certType);
        if (null == privateKey) {
            throw new YopClientException("ConfigProblem, IsvPrivateCert NotFound, appKey:" + appConfig.getAppKey() + ", certType:" + (Object)((Object)certType));
        }
        PKICredentialsItem pkiCredentialsItem = new PKICredentialsItem(privateKey, certType);
        return new YopPKICredentials(appConfig.getAppKey(), pkiCredentialsItem);
    }

    protected String useDefaultIfBlank(String appKey) {
        return StringUtils.defaultIfBlank(appKey, this.getDefaultAppKey());
    }
}

