/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentialsHolder;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProvider;
import com.yeepay.yop.sdk.base.cache.YopCertificateCache;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopBasePlatformCredentialsProvider
implements YopPlatformCredentialsProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopBasePlatformCredentialsProvider.class);
    protected Map<String, YopPlatformCredentials> credentialsMap = Maps.newConcurrentMap();

    @Override
    public YopPlatformCredentials getCredentials(String appKey, String serialNo) {
        return this.getCredentials(appKey, serialNo, null);
    }

    @Override
    public YopPlatformCredentials getCredentials(String appKey, String serialNo, String serverRoot) {
        String realSerialNo;
        if (StringUtils.isBlank(serialNo)) {
            throw new YopClientException("ReqParam Illegal, PlatformCert SerialNo NotSpecified");
        }
        YopPlatformCredentials foundCredentials = this.credentialsMap.computeIfAbsent(serialNo, p -> {
            if (serialNo.equals("rsa")) {
                X509Certificate rsaCert = this.loadLocalRsaCert(appKey, serialNo);
                if (null == rsaCert) {
                    throw new YopClientException("ConfigProblem, LocalRsaCert NotFound, serialNo:" + serialNo);
                }
                return this.convertRsaCredentials(appKey, CertTypeEnum.RSA2048, rsaCert);
            }
            YopPlatformCredentials localCredentials = this.loadCredentialsFromStore(appKey, serialNo);
            if (null == localCredentials) {
                X509Certificate remoteCert = this.loadRemoteSm2Cert(appKey, serialNo, serverRoot);
                if (null == remoteCert) {
                    throw new YopClientException("ConfigProblem, RemoteSm2Cert NotFound, serialNo:" + serialNo);
                }
                return this.storeCredentials(appKey, CertTypeEnum.SM2.name(), remoteCert);
            }
            return localCredentials;
        });
        if (null != foundCredentials && !StringUtils.equals(realSerialNo = foundCredentials.getSerialNo(), serialNo)) {
            this.credentialsMap.put(realSerialNo, foundCredentials);
        }
        return foundCredentials;
    }

    private YopPlatformCredentials convertRsaCredentials(String appKey, CertTypeEnum certType, X509Certificate cert) {
        return new YopPlatformCredentialsHolder().withAppKey(appKey).withSerialNo(X509CertUtils.parseToHex(cert.getSerialNumber().toString())).withCredentials(new PKICredentialsItem(cert.getPublicKey(), certType));
    }

    protected abstract YopPlatformCredentials loadCredentialsFromStore(String var1, String var2);

    protected X509Certificate loadRemoteSm2Cert(String appKey, String serialNo) {
        return this.loadRemoteSm2Cert(appKey, serialNo, null);
    }

    protected X509Certificate loadRemoteSm2Cert(String appKey, String serialNo, String serverRoot) {
        List<X509Certificate> x509Certificates = YopCertificateCache.loadPlatformSm2Certs(appKey, serialNo, serverRoot);
        if (CollectionUtils.isNotEmpty(x509Certificates)) {
            return x509Certificates.get(0);
        }
        return null;
    }

    protected X509Certificate loadLocalRsaCert(String appKey, String serialNo) {
        return YopCertificateCache.getYopPlatformRsaCertFromLocal();
    }

    @Override
    public YopPlatformCredentials getLatestCredentials(String appKey, String credentialType) {
        return this.getLatestCredentials(appKey, credentialType, null);
    }

    @Override
    public YopPlatformCredentials getLatestCredentials(String appKey, String credentialType, String serverRoot) {
        try {
            CertTypeEnum parsedCertType = CertTypeEnum.parse(credentialType);
            if (CertTypeEnum.RSA2048.equals((Object)parsedCertType)) {
                return this.getCredentials(appKey, "rsa", serverRoot);
            }
            return this.getSm2Credentials(appKey, parsedCertType, serverRoot);
        }
        catch (Exception e) {
            LOGGER.warn("getLatestCredentials error, ex:", e);
            LOGGER.warn("No YopPlatformCredentials Found For appKey:{}, credentialType:{}", (Object)appKey, (Object)credentialType);
            return null;
        }
    }

    private YopPlatformCredentials getSm2Credentials(String appKey, CertTypeEnum parsedCertType, String serverRoot) {
        List<X509Certificate> loadedCerts;
        try {
            loadedCerts = YopCertificateCache.loadPlatformSm2Certs(appKey, "", serverRoot);
            if (CollectionUtils.isNotEmpty(loadedCerts) && X509CertUtils.checkCertDate(loadedCerts.get(0))) {
                YopCertificateCache.refreshPlatformSm2Certs(appKey, "", serverRoot);
            }
        }
        catch (CertificateException e) {
            LOGGER.warn("YopPlatformCredentials expired and need reload, appKey:" + appKey + ", credentialType:" + (Object)((Object)parsedCertType) + ", ex", e);
            loadedCerts = YopCertificateCache.reloadPlatformSm2Certs(appKey, "", serverRoot);
        }
        if (CollectionUtils.isEmpty(loadedCerts)) {
            LOGGER.warn("No YopPlatformCredentials Found For appKey:{}, credentialType:{}", (Object)appKey, (Object)parsedCertType);
            return null;
        }
        X509Certificate latestCert = loadedCerts.get(0);
        YopPlatformCredentials credentials = this.storeCredentials(appKey, CertTypeEnum.SM2.name(), latestCert);
        this.credentialsMap.put(credentials.getSerialNo(), credentials);
        return credentials;
    }
}

