/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.signer;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.base.auth.signer.YopSigner;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.SignerTypeEnum;
import java.util.Map;
import java.util.ServiceLoader;

public class YopSignerFactory {
    private static final Map<String, YopSigner> YOP_SIGNER_MAP = Maps.newHashMapWithExpectedSize(3);

    public static void registerSigner(String signerType, YopSigner signer) {
        YOP_SIGNER_MAP.put(signerType, signer);
    }

    @Deprecated
    public static void registerSigner(SignerTypeEnum signerType, YopSigner signer) {
        YopSignerFactory.registerSigner(signerType.name(), signer);
    }

    public static YopSigner getSigner(String signerType) {
        YopSigner yopSigner = YOP_SIGNER_MAP.get(signerType);
        if (null == yopSigner) {
            throw new YopClientException("ConfigProblem, YopSigner NotFound, signerType:" + signerType);
        }
        return yopSigner;
    }

    @Deprecated
    public static YopSigner getSigner(SignerTypeEnum signerType) {
        return YopSignerFactory.getSigner(signerType.name());
    }

    static {
        ServiceLoader<YopSigner> yopSignerLoader = ServiceLoader.load(YopSigner.class);
        for (YopSigner yopSigner : yopSignerLoader) {
            for (String signerType : yopSigner.supportSignerAlg()) {
                YOP_SIGNER_MAP.put(signerType, yopSigner);
            }
        }
    }
}

