/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.signer.process;

import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessor;
import com.yeepay.yop.sdk.exception.YopClientException;
import java.util.Map;
import java.util.ServiceLoader;

public class YopSignProcessorFactory {
    private static final Map<String, YopSignProcessor> YOP_SIGN_PROCESSOR_MAP = Maps.newHashMapWithExpectedSize(4);

    public static YopSignProcessor getSignProcessor(String certType) {
        YopSignProcessor yopSignProcessor = YOP_SIGN_PROCESSOR_MAP.get(certType);
        if (null == yopSignProcessor) {
            throw new YopClientException("ConfigProblem, YopSignProcessor NotFound, certType:" + certType);
        }
        return yopSignProcessor;
    }

    @Deprecated
    public static YopSignProcessor getYopSignProcess(String certType) {
        return YopSignProcessorFactory.getSignProcessor(certType);
    }

    public static void registerSignProcessor(String certType, YopSignProcessor yopSignProcessor) {
        YOP_SIGN_PROCESSOR_MAP.put(certType, yopSignProcessor);
    }

    @Deprecated
    public static void registeYopSignProcess(String certType, YopSignProcessor yopSignProcessor) {
        YopSignProcessorFactory.registerSignProcessor(certType, yopSignProcessor);
    }

    static {
        ServiceLoader<YopSignProcessor> yopSignProcessorLoader = ServiceLoader.load(YopSignProcessor.class);
        for (YopSignProcessor yopSignProcessor : yopSignProcessorLoader) {
            YOP_SIGN_PROCESSOR_MAP.put(yopSignProcessor.name(), yopSignProcessor);
        }
    }
}

