/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.yeepay.shade.com.google.common.cache.CacheBuilder;
import com.yeepay.shade.com.google.common.cache.CacheLoader;
import com.yeepay.shade.com.google.common.cache.LoadingCache;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.base.security.encrypt.RsaEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.Sm2Enhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptionsEnhancer;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptOptionsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptOptionsCache.class);
    private static final LoadingCache<String, Future<EncryptOptions>> ENCRYPT_OPTIONS_CACHE = EncryptOptionsCache.initCache(24L, TimeUnit.HOURS);

    public static Future<EncryptOptions> loadEncryptOptions(String appKey, String encryptAlg) {
        return EncryptOptionsCache.loadEncryptOptions(appKey, encryptAlg, null);
    }

    public static Future<EncryptOptions> loadEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        try {
            return ENCRYPT_OPTIONS_CACHE.get(EncryptOptionsCache.getCacheKey(appKey, encryptAlg, serverRoot));
        }
        catch (ExecutionException e) {
            throw new YopClientException("ConfigProblem, LoadEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", e);
        }
    }

    public static void refreshEncryptOptions(String appKey, String encryptAlg) {
        EncryptOptionsCache.refreshEncryptOptions(appKey, encryptAlg, null);
    }

    public static void refreshEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        try {
            ENCRYPT_OPTIONS_CACHE.refresh(EncryptOptionsCache.getCacheKey(appKey, encryptAlg, serverRoot));
        }
        catch (Exception e) {
            throw new YopClientException("ConfigProblem, RefreshEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", e);
        }
    }

    public static void invalidateEncryptOptions(String appKey, String encryptAlg) {
        EncryptOptionsCache.invalidateEncryptOptions(appKey, encryptAlg, null);
    }

    public static void invalidateEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        try {
            ENCRYPT_OPTIONS_CACHE.invalidate(EncryptOptionsCache.getCacheKey(appKey, encryptAlg, serverRoot));
        }
        catch (Exception e) {
            throw new YopClientException("ConfigProblem, InvalidateEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", e);
        }
    }

    public static Future<EncryptOptions> reloadEncryptOptions(String appKey, String encryptAlg) {
        return EncryptOptionsCache.reloadEncryptOptions(appKey, encryptAlg, null);
    }

    public static Future<EncryptOptions> reloadEncryptOptions(String appKey, String encryptAlg, String serverRoot) {
        try {
            ENCRYPT_OPTIONS_CACHE.invalidate(EncryptOptionsCache.getCacheKey(appKey, encryptAlg, serverRoot));
        }
        catch (Exception e) {
            throw new YopClientException("ConfigProblem, InvalidateEncryptOptions Fail, appKey:" + appKey + ", encryptAlg:" + encryptAlg + ", ex:", e);
        }
        return EncryptOptionsCache.loadEncryptOptions(appKey, encryptAlg, serverRoot);
    }

    private static String getCacheKey(String appKey, String encryptAlg, String serverRoot) {
        return StringUtils.joinWith(",", StringUtils.defaultIfBlank(appKey, "default"), StringUtils.defaultIfBlank(encryptAlg, ""), StringUtils.defaultIfBlank(serverRoot, ""));
    }

    private static LoadingCache<String, Future<EncryptOptions>> initCache(Long expire, TimeUnit timeUnit) {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (expire > 0L) {
            cacheBuilder.expireAfterWrite(expire, timeUnit);
        }
        return cacheBuilder.build(new CacheLoader<String, Future<EncryptOptions>>(){

            @Override
            public Future<EncryptOptions> load(String cacheKey) throws Exception {
                LOGGER.debug("try to init encryptOptions for cacheKey:" + cacheKey);
                Future<EncryptOptions> encryptOptions = null;
                try {
                    String[] split = StringUtils.splitPreserveAllTokens(cacheKey, ",");
                    String appKey = split[0];
                    String encryptAlg = split[1];
                    String serverRoot = split.length > 2 ? split[2] : null;
                    YopEncryptor encryptor = YopEncryptorFactory.getEncryptor(encryptAlg);
                    List<EncryptOptionsEnhancer> enhancers = Collections.singletonList(EncryptOptionsCache.getEnhancer(appKey, encryptAlg, serverRoot));
                    encryptOptions = encryptor.initOptions(encryptAlg, enhancers);
                }
                catch (Exception ex) {
                    LOGGER.warn("UnexpectedException occurred when init encryptOptions for cacheKey:" + cacheKey, ex);
                }
                return encryptOptions;
            }
        });
    }

    private static EncryptOptionsEnhancer getEnhancer(String appKey, String encryptAlg, String serverRoot) {
        switch (encryptAlg) {
            case "SM4/CBC/PKCS5Padding": {
                return new Sm2Enhancer(appKey, "", serverRoot);
            }
            case "AES": 
            case "AES/ECB/PKCS5Padding": {
                return new RsaEnhancer(appKey);
            }
        }
        throw new YopClientException("not supported encryptAlg:" + encryptAlg);
    }
}

