/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.yeepay.shade.com.google.common.cache.CacheBuilder;
import com.yeepay.shade.com.google.common.cache.CacheLoader;
import com.yeepay.shade.com.google.common.cache.LoadingCache;
import com.yeepay.shade.com.google.common.collect.Lists;
import com.yeepay.shade.org.apache.commons.collections4.CollectionUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.cache.YopCredentialsCache;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParserFactory;
import com.yeepay.yop.sdk.client.YopGlobalClient;
import com.yeepay.yop.sdk.config.enums.CertStoreType;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.model.cert.YopPlatformCertQueryResult;
import com.yeepay.yop.sdk.model.cert.YopPlatformPlainCert;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import com.yeepay.yop.sdk.security.cert.YopPublicKey;
import com.yeepay.yop.sdk.service.common.YopClient;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import com.yeepay.yop.sdk.service.common.response.YopResponse;
import com.yeepay.yop.sdk.utils.EnvUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopCertificateCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopCertificateCache.class);
    private static final String CERT_DOWNLOAD_API_URI = "/rest/v2.0/yop/platform/certs";
    private static final String CERT_DOWNLOAD_API_METHOD = "GET";
    private static final String CERT_DOWNLOAD_API_SECURITY = "YOP-SM2-SM3";
    private static final String CERT_DOWNLOAD_API_PARAM_SERIAL_NO = "serialNo";
    private static final String CERT_DOWNLOAD_API_PARAM_CERT_TYPE = "certType";
    private static final LoadingCache<String, List<X509Certificate>> PLATFORM_CERT_CACHE = YopCertificateCache.initCache(24L, TimeUnit.HOURS);
    private static YopClient YOP_CLIENT;
    private static X509Certificate CFCA_ROOT_CERT;
    private static X509Certificate YOP_INTER_CERT;
    private static X509Certificate YOP_PLATFORM_RSA_CERT;
    private static final String QA_RSA_CERT_SERIAL_NO = "4032156487";
    private static final String PRO_RSA_CERT_SERIAL_NO = "4397139598";

    public static X509Certificate getCfcaRootCertFromLocal() {
        return CFCA_ROOT_CERT;
    }

    public static X509Certificate getYopInterCertFromLocal() {
        return YOP_INTER_CERT;
    }

    public static X509Certificate getYopPlatformRsaCertFromLocal() {
        return YOP_PLATFORM_RSA_CERT;
    }

    public static List<X509Certificate> loadPlatformSm2Certs(String appKey, String serialNo) {
        return YopCertificateCache.loadPlatformSm2Certs(appKey, serialNo, null);
    }

    public static List<X509Certificate> loadPlatformSm2Certs(String appKey, String serialNo, String serverRoot) {
        String cacheKey = YopCertificateCache.getCacheKey(appKey, serialNo, serverRoot);
        return YopCertificateCache.loadPlatformSm2Certs(cacheKey);
    }

    private static List<X509Certificate> loadPlatformSm2Certs(String cacheKey) {
        try {
            List<X509Certificate> cachedCerts = PLATFORM_CERT_CACHE.get(cacheKey);
            if (CollectionUtils.isNotEmpty(cachedCerts)) {
                return cachedCerts;
            }
            PLATFORM_CERT_CACHE.invalidate(cacheKey);
        }
        catch (Exception e) {
            LOGGER.warn("UnexpectedException occurred when load platformCert for cacheKey:" + cacheKey, e);
        }
        return null;
    }

    public static List<X509Certificate> refreshPlatformSm2Certs(String appKey, String serialNo) {
        return YopCertificateCache.refreshPlatformSm2Certs(appKey, serialNo, null);
    }

    public static List<X509Certificate> refreshPlatformSm2Certs(String appKey, String serialNo, String serverRoot) {
        String cacheKey = YopCertificateCache.getCacheKey(appKey, serialNo, serverRoot);
        try {
            PLATFORM_CERT_CACHE.refresh(cacheKey);
        }
        catch (Exception e) {
            LOGGER.warn("UnexpectedException occurred when refresh platformCert for cacheKey:" + cacheKey, e);
        }
        return YopCertificateCache.loadPlatformSm2Certs(cacheKey);
    }

    public static List<X509Certificate> reloadPlatformSm2Certs(String appKey, String serialNo) {
        return YopCertificateCache.reloadPlatformSm2Certs(appKey, serialNo, null);
    }

    public static List<X509Certificate> reloadPlatformSm2Certs(String appKey, String serialNo, String serverRoot) {
        String cacheKey = YopCertificateCache.getCacheKey(appKey, serialNo, serverRoot);
        try {
            PLATFORM_CERT_CACHE.invalidate(cacheKey);
        }
        catch (Exception e) {
            LOGGER.warn("UnexpectedException occurred when invalidate platformCert for cacheKey:" + cacheKey, e);
        }
        return YopCertificateCache.loadPlatformSm2Certs(cacheKey);
    }

    private static String getCacheKey(String appKey, String serialNo, String serverRoot) {
        return StringUtils.joinWith(",", StringUtils.defaultIfBlank(appKey, "default"), StringUtils.defaultIfBlank(serialNo, ""), StringUtils.defaultIfBlank(serverRoot, ""));
    }

    private static synchronized List<X509Certificate> doLoad(YopCredentials<?> yopCredentials, String serialNo, String serverRoot) {
        List<X509Certificate> result = Collections.emptyList();
        try {
            YopRequest request = new YopRequest(CERT_DOWNLOAD_API_URI, CERT_DOWNLOAD_API_METHOD);
            request.getRequestConfig().setSkipVerifySign(true).setNeedEncrypt(false).setSecurityReq(CERT_DOWNLOAD_API_SECURITY).setCredentials(yopCredentials);
            if (StringUtils.isNotBlank(serialNo)) {
                request.addParameter(CERT_DOWNLOAD_API_PARAM_SERIAL_NO, serialNo);
            }
            if (StringUtils.isNotBlank(serverRoot)) {
                request.getRequestConfig().setServerRoot(serverRoot);
            }
            request.addParameter(CERT_DOWNLOAD_API_PARAM_CERT_TYPE, CertTypeEnum.SM2.getValue());
            YopResponse response = YOP_CLIENT.request(request);
            List<YopPlatformPlainCert> platformCerts = YopCertificateCache.parseYopResponse(response);
            List<X509Certificate> legalPlatformCerts = YopCertificateCache.checkCerts(platformCerts);
            if (CollectionUtils.isNotEmpty(legalPlatformCerts)) {
                result = legalPlatformCerts;
            }
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 cert from remote, ex:", e);
        }
        return result;
    }

    private static List<YopPlatformPlainCert> parseYopResponse(YopResponse response) {
        try {
            YopPlatformCertQueryResult bizResponse = new YopPlatformCertQueryResult();
            JsonUtils.load(response.getStringResult(), (Object)bizResponse);
            return bizResponse.getData();
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 cert, ex:", e);
            return Collections.emptyList();
        }
    }

    private static List<X509Certificate> checkCerts(List<YopPlatformPlainCert> platformCerts) {
        if (CollectionUtils.isNotEmpty(platformCerts)) {
            ArrayList<X509Certificate> result = Lists.newArrayList();
            for (YopPlatformPlainCert platformCert : platformCerts) {
                X509Certificate tmp = YopCertificateCache.decodeCert(platformCert);
                if (null != tmp) {
                    tmp = YopCertificateCache.verifyCert(tmp);
                }
                if (null == tmp) continue;
                result.add(tmp);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static X509Certificate decodeCert(YopPlatformPlainCert platformCert) {
        try {
            byte[] certBytes = platformCert.getCert().getBytes("UTF-8");
            return X509CertUtils.getX509Certificate(CertTypeEnum.SM2, certBytes);
        }
        catch (Exception e) {
            LOGGER.warn("fail to decode platform cert:" + platformCert + ", ex:", e);
            return null;
        }
    }

    private static X509Certificate verifyCert(X509Certificate platformCert) {
        try {
            X509CertUtils.verifyCertificate(CertTypeEnum.SM2, YOP_INTER_CERT.getPublicKey(), platformCert);
            return platformCert;
        }
        catch (Exception e) {
            LOGGER.error("error to verify platform cert:" + platformCert + ", ex:", e);
            return null;
        }
    }

    private static X509Certificate getX509Cert(String certPath, CertTypeEnum certType) {
        YopCertConfig yopCertConfig = new YopCertConfig();
        yopCertConfig.setCertType(certType);
        yopCertConfig.setValue(certPath);
        yopCertConfig.setStoreType(CertStoreType.FILE_CER);
        return ((YopPublicKey)YopCertParserFactory.getCertParser(YopCertCategory.PUBLIC, certType).parse(yopCertConfig)).getCert();
    }

    private static LoadingCache<String, List<X509Certificate>> initCache(Long expire, TimeUnit timeUnit) {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (expire > 0L) {
            cacheBuilder.expireAfterWrite(expire, timeUnit);
        }
        return cacheBuilder.build(new CacheLoader<String, List<X509Certificate>>(){

            @Override
            public List<X509Certificate> load(String cacheKey) throws Exception {
                LOGGER.debug("try to init platform cert for cacheKey:" + cacheKey);
                List platformCert = Collections.emptyList();
                try {
                    String[] split = StringUtils.splitPreserveAllTokens(cacheKey, ",");
                    String appKey = split[0];
                    String serialNo = split.length > 1 ? split[1] : null;
                    String serverRoot = split.length > 2 ? split[2] : null;
                    platformCert = YopCertificateCache.doLoad(YopCredentialsCache.get(appKey), serialNo, serverRoot);
                }
                catch (Exception ex) {
                    LOGGER.warn("UnexpectedException occurred when init platformCert for cacheKey:" + cacheKey, ex);
                }
                return platformCert;
            }
        });
    }

    static {
        String cfcaRootFile = "cfca_root.pem";
        String yopInterFile = "yop_inter.pem";
        String yopPlatformRsaCertSerialNo = PRO_RSA_CERT_SERIAL_NO;
        if (!EnvUtils.isProd()) {
            String env = EnvUtils.currentEnv();
            String envPrefix = StringUtils.substringBefore(env, "_");
            cfcaRootFile = envPrefix + "_" + "cfca_root.pem";
            yopInterFile = envPrefix + "_" + "yop_inter.pem";
            yopPlatformRsaCertSerialNo = QA_RSA_CERT_SERIAL_NO;
        }
        try {
            CFCA_ROOT_CERT = YopCertificateCache.getX509Cert("config/certs/" + cfcaRootFile, CertTypeEnum.SM2);
            X509CertUtils.verifyCertificate(CertTypeEnum.SM2, null, CFCA_ROOT_CERT);
            YOP_INTER_CERT = YopCertificateCache.getX509Cert("config/certs/" + yopInterFile, CertTypeEnum.SM2);
            X509CertUtils.verifyCertificate(CertTypeEnum.SM2, CFCA_ROOT_CERT.getPublicKey(), YOP_INTER_CERT);
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 parent certs, if you dont use sm2 just ignore it, ex:", e);
        }
        try {
            YOP_PLATFORM_RSA_CERT = YopCertificateCache.getX509Cert("config/certs/yop_platform_rsa_cert_" + yopPlatformRsaCertSerialNo + ".cer", CertTypeEnum.RSA2048);
        }
        catch (Exception e) {
            LOGGER.warn("error when load yop rsa certs\uff0cif you dont use rsa just ignore it, ex:", e);
        }
        YOP_CLIENT = YopGlobalClient.getClient();
    }
}

